<?php if(isset($flightData) && !empty($flightData)): ?>
    <?php
        $airline = $flightData['airline'] ?? 'unknown';
        $isEmirate = $airline === 'emirate';
        $isFlyJinnah = $airline === 'flyjinnah';
        $isAirblue = $airline === 'airblue';
        $isPIA = $airline === 'pia';

        $logo = $flightData['airline'] ?? 'default';

        // Handle Airblue flights array structure
        if ($isAirblue && isset($flightData['flights']) && is_array($flightData['flights'])) {
            $flights = $flightData['flights'];
            $totalPrice = 0;
            $totalBase = 0;
            $totalTax = 0;
            $totalFees = 0;

            foreach ($flights as $flightItem) {
                if (isset($flightItem['bundle'])) {
                    $totalPrice += (float) ($flightItem['bundle']['total_price'] ?? 0);
                    $totalBase += (float) ($flightItem['bundle']['base_price'] ?? 0);
                    $totalTax += (float) ($flightItem['bundle']['taxes'] ?? 0);
                    $totalFees += (float) ($flightItem['bundle']['fees'] ?? 0);
                }
            }
        } else {
            // Original structure for flyjinnah and emirates
            $departure = $flightData['departure'] ?? null;
            $originCode = $departure['departure']['code'] ?? '';
            $destinationCode = $departure['arrival']['code'] ?? '';
            $depTime = $departure['departure']['time'] ?? '';
            $arrTime = $departure['arrival']['time'] ?? '';
            $depTimeDiff = $departure['duration'] ?? '';
            $depDate = $departure['departure']['date'] ?? '';
            $stopCount = count($departure['segments'] ?? []) - 1;

            $hasReturn = isset($flightData['return']);
            if ($hasReturn) {
                $return = $flightData['return'];
                $returnOriginCode = $return['departure']['code'] ?? '';
                $returnDestinationCode = $return['arrival']['code'] ?? '';
                $returnDepTime = $return['departure']['time'] ?? '';
                $returnArrTime = $return['arrival']['time'] ?? '';
                $returnTimeDiff = $return['duration'] ?? '';
                $returnStopCount = count($return['segments'] ?? []) - 1;
            }

            $outboundBundle = $flightData['firstBundle'] ?? null;
            $returnBundle = $flightData['returnBundle'] ?? null;

            // For PIA, extract price from the total_price_pkr field
            if ($isPIA) {
                $totalPrice = (float) ($flightData['total_price_pkr'] ?? 0);
                $totalBase = $totalPrice; // PIA doesn't provide separate breakdown
                $totalTax = 0;
                $totalFees = 0;
            } else {
                $totalPrice = ($outboundBundle['total_price'] ?? 0) + ($returnBundle['total_price'] ?? 0);
                $totalBase = ($outboundBundle['base_price'] ?? 0) + ($returnBundle['base_price'] ?? 0);
                $totalTax = ($outboundBundle['taxes'] ?? 0) + ($returnBundle['taxes'] ?? 0);
                $totalFees = ($outboundBundle['fees'] ?? 0) + ($returnBundle['fees'] ?? 0);
            }
        }
    ?>

    
    <div class="bokkings-bar">
        <div class="book-head">
            <div class="youbook">
                <h2>Your Bookings</h2>
            </div>
            <?php if($isAirblue && isset($flights) && count($flights) > 2): ?>
                <div class="depar-head">
                    <ul>
                        <li>
                            <p>Multi-City Flight</p>
                        </li>
                        <li>
                            
                        </li>
                    </ul>
                </div>
            <?php else: ?>
                <div class="depar-head">
                    <ul>
                        <li>
                            <p>Departing</p>
                        </li>
                        <li>
                            <p><i class="fa-regular fa-calendar"></i> <?php echo e($depDate ?? ''); ?></p>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>
        </div>

        <div class="book-flex">
            <div class="emr w-25">
                <img src="<?php echo e(asset('assets/images/logos/modal/' . $logo . '.png')); ?>" alt="<?php echo e(strtoupper($logo)); ?>"
                    onerror="this.src='<?php echo e(asset('assets/images/logos/modal/default.png')); ?>'">
            </div>
        </div>

        <div class="d-flex flex-column">
            <?php if($isAirblue && isset($flights)): ?>
                
                <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $flightItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $flight = $flightItem['departure'] ?? null;
                        if (!$flight) {
                            continue;
                        }

                        $originCode = $flight['departure']['code'] ?? '';
                        $destinationCode = $flight['arrival']['code'] ?? '';
                        $depTime = $flight['departure']['time'] ?? '';
                        $arrTime = $flight['arrival']['time'] ?? '';
                        $depTimeDiff = $flight['duration'] ?? '';
                        $depDate = $flight['departure']['date'] ?? '';
                        $stopCount = count($flight['segments'] ?? []) - 1;
                        $legNumber = $index + 1;
                    ?>
                    <div class="der-time der-time3 mb-2">
                        <div class="mb-2">
                            
                            <small class="text-muted ms-2"><?php echo e($depDate); ?></small>
                        </div>
                        <ul>
                            <li>
                                <h2><?php echo e($depTime); ?></h2>
                            </li>
                            <li>
                                <div class="stays">
                                    <p><?php echo e($depTimeDiff); ?></p>
                                </div>
                            </li>
                            <li>
                                <div class="tims">
                                    <h2><?php echo e($arrTime); ?></h2>
                                </div>
                            </li>
                        </ul>
                        <div class="citys citys2">
                            <div class="cit">
                                <ul>
                                    <li>
                                        <p><?php echo e($originCode); ?></p>
                                    </li>
                                    <li>
                                        <p><?php echo e($stopCount > 0 ? $stopCount . ' ' . Str::plural('Stop', $stopCount) : 'Nonstop'); ?>

                                        </p>
                                    </li>
                                    <li>
                                        <p><?php echo e($destinationCode); ?></p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                
                
                <?php if(isset($departure)): ?>
                    <div class="der-time der-time3 mb-2">
                        <ul>
                            <li>
                                <h2><?php echo e($depTime); ?></h2>
                            </li>
                            <li>
                                <div class="stays">
                                    <p><?php echo e($depTimeDiff); ?></p>
                                </div>
                            </li>
                            <li>
                                <div class="tims">
                                    <h2><?php echo e($arrTime); ?></h2>
                                </div>
                            </li>
                        </ul>
                        <div class="citys citys2">
                            <div class="cit">
                                <ul>
                                    <li>
                                        <p><?php echo e($originCode); ?></p>
                                    </li>
                                    <li>
                                        <p><?php echo e($stopCount > 0 ? $stopCount . ' ' . Str::plural('Stop', $stopCount) : 'Nonstop'); ?>

                                        </p>
                                    </li>
                                    <li>
                                        <p><?php echo e($destinationCode); ?></p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                
                <?php if(isset($hasReturn) && $hasReturn): ?>
                    <div class="der-time der-time3 mb-2">
                        <ul>
                            <li>
                                <h2><?php echo e($returnDepTime); ?></h2>
                            </li>
                            <li>
                                <div class="stays">
                                    <p><?php echo e($returnTimeDiff); ?></p>
                                </div>
                            </li>
                            <li>
                                <div class="tims">
                                    <h2><?php echo e($returnArrTime); ?></h2>
                                </div>
                            </li>
                        </ul>
                        <div class="citys citys2">
                            <div class="cit">
                                <ul>
                                    <li>
                                        <p><?php echo e($returnOriginCode); ?></p>
                                    </li>
                                    <li>
                                        <p><?php echo e($returnStopCount > 0 ? $returnStopCount . ' ' . Str::plural('Stop', $returnStopCount) : 'Nonstop'); ?>

                                        </p>
                                    </li>
                                    <li>
                                        <p><?php echo e($returnDestinationCode); ?></p>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

    
    <div class="bokkings-bar bokkings-bar2 priceSummaryContainer">
        <div class="book-head">
            <div class="youbook">
                <h2><span>Price Summary</span></h2>
            </div>
        </div>

        <div class="der-time der-time3">
            <?php if($isEmirate): ?>
                
                <?php if(!empty($flightData['flightDetails']['bundle']['offerItem'] ?? [])): ?>
                    <?php $__currentLoopData = $flightData['flightDetails']['bundle']['offerItem']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="emr-adul justify-content-between">
                            <p><?php echo e($offer['fareDetail']['passengers'] ?? 'Passenger'); ?></p>
                            <p>PKR <?php echo e(number_format($offer['totalPrice']['amount'] ?? 0)); ?></p>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <div class="emr-adul justify-content-between">
                        <p>Flight Fare</p>
                        <p>PKR <?php echo e(number_format($flightData['flightDetails']['bundle']['totalPrice']['amount'] ?? 0)); ?>

                        </p>
                    </div>
                <?php endif; ?>
                <div class="emr-adul justify-content-between">
                    <p>Taxes & Fees</p>
                    <p>PKR <?php echo e($tax ?? 0); ?></p>
                </div>
            <?php elseif($isFlyJinnah): ?>
                
                <div class="emr-adul justify-content-between">
                    <p>Flight
                        <?php echo e(isset($flightData['isDirectBooking']) && !$flightData['isDirectBooking'] ? 'with Bundle' : 'Price'); ?>

                    </p>
                    <p><?php echo e($totalFare['TotalFare']['@attributes']['CurrencyCode'] ?? 'PKR'); ?>

                        <?php echo e($totalFare['TotalFare']['@attributes']['Amount'] ?? 0); ?></p>
                </div>
                <div class="emr-adul justify-content-between">
                    <p>Tax</p>
                    <p>PKR <?php echo e($tax ?? 0); ?></p>
                </div>
            <?php elseif($isPIA): ?>
                
                <div class="emr-adul justify-content-between">
                    <p>Flight Fare (<?php echo e($flightData['paxCount']['adt'] ?? 1); ?> <?php echo e(($flightData['paxCount']['adt'] ?? 1) > 1 ? 'Adults' : 'Adult'); ?>)</p>
                    <p>PKR <?php echo e(number_format((float) ($flightData['total_price_pkr'] ?? 0))); ?></p>
                </div>
                <?php if(($flightData['paxCount']['chd'] ?? 0) > 0): ?>
                    <div class="emr-adul justify-content-between">
                        <p>Children (<?php echo e($flightData['paxCount']['chd']); ?>)</p>
                        <p>Included</p>
                    </div>
                <?php endif; ?>
                <?php if(($flightData['paxCount']['inf'] ?? 0) > 0): ?>
                    <div class="emr-adul justify-content-between">
                        <p>Infants (<?php echo e($flightData['paxCount']['inf']); ?>)</p>
                        <p>Included</p>
                    </div>
                <?php endif; ?>
                <div class="border-top pt-3 mt-2">
                    <div class="emr-adul justify-content-between">
                        <p><strong>Outbound Bundle:</strong> <?php echo e(strtoupper($flightData['outbound_bundle'] ?? 'N/A')); ?></p>
                    </div>
                    <?php if(isset($flightData['inbound_bundle'])): ?>
                        <div class="emr-adul justify-content-between">
                            <p><strong>Inbound Bundle:</strong> <?php echo e(strtoupper($flightData['inbound_bundle'])); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                
                <?php if($isAirblue && isset($flights)): ?>
                    
                    <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $flightItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $bundle = $flightItem['bundle'] ?? null;
                            if (!$bundle) {
                                continue;
                            }
                            $flight = $flightItem['departure'] ?? null;
                            $originCode = $flight['departure']['code'] ?? '';
                            $destinationCode = $flight['arrival']['code'] ?? '';
                            $routeLabel =
                                $originCode && $destinationCode ? "{$originCode}-{$destinationCode}" : 'Flight';
                        ?>
                        <div class="align-items-center emr-adul justify-content-between mb-2">
                            <div class="align-items-center gap-2 w-100">
                                <span class="badge px-3 py-2 text-white"
                                    style="background: <?php echo e($bundle['color'] ?? '#6c757d'); ?>">
                                    <?php echo e($bundle['bundle_name'] ?? 'Standard'); ?>

                                </span>
                                <small class="text-muted">(<?php echo e($routeLabel); ?>)</small>
                                <strong class="float-right">PKR
                                    <?php echo e(number_format((float) ($bundle['total_price'] ?? 0))); ?></strong>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <!-- Breakdown -->
                    <div class="border-top pt-3 mt-2 small text-muted">
                        <div class="d-flex justify-content-between"><span>Base Fare</span><span>PKR
                                <?php echo e(number_format($totalBase)); ?></span></div>
                        <div class="d-flex justify-content-between"><span>Taxes</span><span>PKR
                                <?php echo e(number_format($totalTax)); ?></span></div>
                        <div class="d-flex justify-content-between"><span>Fees & Charges</span><span>PKR
                                <?php echo e(number_format($totalFees)); ?></span></div>
                    </div>
                <?php else: ?>
                    
                    <!-- Outbound Bundle -->
                    <div class="align-items-center emr-adul justify-content-between mb-2">
                        <div class="align-items-center gap-2 w-100">
                            <span class="badge px-3 py-2 text-white"
                                style="background: <?php echo e($outboundBundle['color'] ?? '#6c757d'); ?>">
                                <?php echo e($outboundBundle['bundle_name'] ?? 'Standard'); ?>

                            </span>
                            <small
                                class="text-muted">(<?php echo e(isset($hasReturn) && $hasReturn ? 'Outbound' : 'Flight'); ?>)</small>
                            <strong class="float-right">PKR
                                <?php echo e(number_format($outboundBundle['total_price'] ?? 0)); ?></strong>
                        </div>
                    </div>

                    <!-- Return Bundle -->
                    <?php if(isset($returnBundle) && $returnBundle): ?>
                        <div class="emr-adul justify-content-between align-items-center mb-3">
                            <div class="align-items-center gap-2 w-100">
                                <span class="badge px-3 py-2 text-white"
                                    style="background: <?php echo e($returnBundle['color'] ?? '#6c757d'); ?>">
                                    <?php echo e($returnBundle['bundle_name'] ?? 'Standard'); ?>

                                </span>
                                <small class="text-muted">(Return)</small>
                                <strong class="float-right">PKR
                                    <?php echo e(number_format($returnBundle['total_price'] ?? 0)); ?></strong>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Breakdown -->
                    <div class="border-top pt-3 mt-2 small text-muted">
                        <div class="d-flex justify-content-between"><span>Base Fare</span><span>PKR
                                <?php echo e(number_format($totalBase)); ?></span></div>
                        <div class="d-flex justify-content-between"><span>Taxes</span><span>PKR
                                <?php echo e(number_format($totalTax)); ?></span></div>
                        <div class="d-flex justify-content-between"><span>Fees & Charges</span><span>PKR
                                <?php echo e(number_format($totalFees)); ?></span></div>
                    </div>
                <?php endif; ?>
            <?php endif; ?>

            
            <div class="pri-pak mt-4">
                <h2>Total price you pay</h2>
                <p class="Rfs">
                    PKR
                    <?php echo e(number_format(
                        $isEmirate
                            ? ($flightData['flightDetails']['bundle']['totalPrice']['amount'] ?? 0) + ($tax ?? 0)
                            : ($isFlyJinnah
                                ? ($totalFare['TotalFare']['@attributes']['Amount'] ?? 0) + ($tax ?? 0)
                                : $totalPrice + ($tax ?? 0)),
                    )); ?>

                </p>
            </div>
        </div>
    </div>

    
    <?php if($isEmirate || (!$isEmirate && !$isFlyJinnah && !$isPIA)): ?>
        <div class="bokkings-bar bokkings-bar2 penaltiesContainer">
            <div class="book-head">
                <div class="youbook">
                    <h2><span>Penalties</span></h2>
                </div>
                <div class="youbook">
                    <p class="text-info font-weight-bolder toggle-panelties-details pointer">
                        <span class="toggle-text">Show details</span>
                        <i class="fas fa-chevron-down toggle-icon transition-all duration-300"></i>
                    </p>
                </div>
            </div>
            <div class="der-time der-time3 panelties-details" style="display: none;">
                <?php if($isEmirate): ?>
                    <?php $__currentLoopData = $flightData['flightDetails']['bundle']['offerItem'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="emr-adul justify-content-between">
                            <h2><?php echo e($offer['fareDetail']['passengers'] ?? ''); ?></h2>
                        </div>
                        <?php $__currentLoopData = $offer['fareDetail']['penalties'] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penalty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="emr-adul justify-content-between">
                                <p><?php echo e($penalty['arrival'] ?? ''); ?></p>
                                <p><?php echo e($penalty['destination'] ?? ''); ?></p>
                            </div>
                            <?php if(!empty($penalty['fareRules']['cancelFee'])): ?>
                                <div class="mt-2"><strong class="font-weight-bolder">Cancel Fee</strong></div>
                                <?php $__currentLoopData = $penalty['fareRules']['cancelFee']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="emr-adul justify-content-between">
                                        <p><?php echo e($label); ?></p>
                                        <?php if(isset($fee['price'])): ?>
                                            <p>
                                                <?php echo e($fee['price']['amount'] ?? '-'); ?>

                                                <?php echo e($fee['price']['code'] ?? ''); ?>

                                                <small class="small">(<?php echo e($fee['amountApplication'] ?? ''); ?>)</small>
                                            </p>
                                        <?php else: ?>
                                            <p><?php echo e($fee); ?></p>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(!empty($penalty['fareRules']['changeFee'])): ?>
                                <div class="mt-2"><strong class="font-weight-bolder">Change Fee</strong></div>
                                <?php $__currentLoopData = $penalty['fareRules']['changeFee']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="emr-adul justify-content-between">
                                        <p><?php echo e($label); ?></p>
                                        <?php if(isset($fee['price'])): ?>
                                            <p>
                                                <?php echo e($fee['price']['amount'] ?? '-'); ?>

                                                <?php echo e($fee['price']['code'] ?? ''); ?>

                                                <small class="small">(<?php echo e($fee['amountApplication'] ?? ''); ?>)</small>
                                            </p>
                                        <?php else: ?>
                                            <p><?php echo e($fee); ?></p>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(!empty($penalty['fareRules']['refundFee'])): ?>
                                <div class="mt-2"><strong class="font-weight-bolder">Refund Fee</strong></div>
                                <?php $__currentLoopData = $penalty['fareRules']['refundFee']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $label => $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="emr-adul justify-content-between">
                                        <p><?php echo e($label); ?></p>
                                        <?php if(isset($fee['price'])): ?>
                                            <p>
                                                <?php echo e($fee['price']['amount'] ?? '-'); ?>

                                                <?php echo e($fee['price']['code'] ?? ''); ?>

                                                <small class="small">(<?php echo e($fee['amountApplication'] ?? ''); ?>)</small>
                                            </p>
                                        <?php else: ?>
                                            <p><?php echo e($fee); ?></p>
                                        <?php endif; ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <br>
                            <hr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <?php
                        $renderPenalty = function ($bundle, $leg) {
                            if (!$bundle) {
                                return;
                            }
                            echo '<div class="p-3 mb-4 rounded" style="background:#f8f9fa;">';
                            echo '<h6 class="font-weight-bold text-primary">' .
                                ($bundle['bundle_name'] ?? 'Bundle') .
                                ' – ' .
                                $leg .
                                '</h6>';
                            echo '<small class="text-success">Baggage: ' .
                                ($bundle['baggage'] ?? 'Not included') .
                                '</small>';
                            if (!empty($bundle['change_penalty'] ?? [])) {
                                echo '<div class="my-3"><strong class="font-weight-bold">Change Penalty</strong></div>';
                                foreach ($bundle['change_penalty'] as $p) {
                                    echo '<div class="d-flex justify-content-between"><span>' .
                                        e($p['label']) .
                                        '</span><span class="text-danger">PKR ' .
                                        number_format($p['amount']) .
                                        '</span></div>';
                                }
                            }
                            if (!empty($bundle['refund_penalty'] ?? [])) {
                                echo '<div class="my-3"><strong class="font-weight-bold">Cancellation / Refund Penalty</strong></div>';
                                foreach ($bundle['refund_penalty'] as $p) {
                                    echo '<div class="d-flex justify-content-between"><span>' .
                                        e($p['label']) .
                                        '</span><span class="text-danger">PKR ' .
                                        number_format($p['amount']) .
                                        '</span></div>';
                                }
                            }
                            echo '</div>';
                        };
                    ?>
                    <?php if($isAirblue && isset($flights)): ?>
                        
                        <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $flightItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $bundle = $flightItem['bundle'] ?? null;
                                if (!$bundle) {
                                    continue;
                                }
                                $flight = $flightItem['departure'] ?? null;
                                $originCode = $flight['departure']['code'] ?? '';
                                $destinationCode = $flight['arrival']['code'] ?? '';
                                $routeLabel =
                                    $originCode && $destinationCode ? "{$originCode}-{$destinationCode}" : 'Journey';
                            ?>
                            <?php echo $renderPenalty($bundle, $routeLabel); ?>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        
                        <?php echo $renderPenalty($outboundBundle ?? null, isset($hasReturn) && $hasReturn ? 'Outbound' : 'Journey'); ?>

                        <?php if(isset($returnBundle) && $returnBundle): ?>
                            <?php echo $renderPenalty($returnBundle, 'Return'); ?>

                        <?php endif; ?>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
<?php endif; ?><?php /**PATH D:\wamp64\www\destination-travel\resources\views/components/flight-and-price.blade.php ENDPATH**/ ?>