<div class="modal-body">
    <?php
        $bookingRequest = $booking->bookingRequest ?? null;
        $xmlBody = $bookingRequest && isset($bookingRequest->xml_body) ? json_decode($bookingRequest->xml_body, true) : null;
        $airline = strtolower($booking->airline);
    ?>
    <?php if($bookingRequest): ?>
        <?php if($airline === 'emirates'): ?>
            <div class="accordion" id="bookingAccordion">
                <!-- General Booking Information -->
                <div class="accordion-item">
                    <h2 class="accordion-header" id="generalInfoHeading">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#generalInfo" aria-expanded="true" aria-controls="generalInfo">
                            General Booking Information Emirates
                        </button>
                    </h2>
                    <div id="generalInfo" class="accordion-collapse collapse show" aria-labelledby="generalInfoHeading" data-bs-parent="#bookingAccordion">
                        <div class="accordion-body">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item"><strong>ID:</strong> <?php echo e($bookingRequest->id ?? 'N/A'); ?></li>
                                <li class="list-group-item"><strong>Airline:</strong>
                                    <?php echo e($bookingRequest->airline ?? 'N/A'); ?></li>
                                <li class="list-group-item"><strong>Ticket Limit:</strong>
                                    <?php echo e(isset($bookingRequest->ticket_limit) ? \Carbon\Carbon::parse($bookingRequest->ticket_limit)->format('d M Y, H:i') : 'N/A'); ?>

                                </li>
                                <li class="list-group-item"><strong>Payment Limit:</strong>
                                    <?php echo e(isset($bookingRequest->payment_limit) ? \Carbon\Carbon::parse($bookingRequest->payment_limit)->format('d M Y, H:i') : 'N/A'); ?>

                                </li>
                                <li class="list-group-item"><strong>Status:</strong>
                                    <?php echo e(isset($bookingRequest->status) ? ucfirst($bookingRequest->status) : 'N/A'); ?></li>
                                <li class="list-group-item"><strong>Client ID:</strong>
                                    <?php echo e($bookingRequest->client_id ?? 'N/A'); ?></li>
                                <li class="list-group-item"><strong>Booking ID:</strong>
                                    <?php echo e($bookingRequest->booking_id ?? 'N/A'); ?></li>
                                <li class="list-group-item"><strong>Created At:</strong>
                                    <?php echo e(isset($bookingRequest->created_at) ? \Carbon\Carbon::parse($bookingRequest->created_at)->format('d M Y, H:i') : 'N/A'); ?>

                                </li>
                                <li class="list-group-item"><strong>Updated At:</strong>
                                    <?php echo e(isset($bookingRequest->updated_at) ? \Carbon\Carbon::parse($bookingRequest->updated_at)->format('d M Y, H:i') : 'N/A'); ?>

                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Passenger Information -->
                <?php if($xmlBody && isset($xmlBody['passengers']) && !empty($xmlBody['passengers'])): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="passengerInfoHeading">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#passengerInfo" aria-expanded="false" aria-controls="passengerInfo">
                                Passenger Information
                            </button>
                        </h2>
                        <div id="passengerInfo" class="accordion-collapse collapse"
                            aria-labelledby="passengerInfoHeading" data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="card mb-3">
                                        <div class="card-header">
                                            Passenger <?php echo e($passenger['id'] ?? 'Unknown'); ?>

                                            (<?php echo e($passenger['type'] ?? 'N/A'); ?>)
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><strong>Name:</strong>
                                                    <?php echo e(isset($passenger['title']) ? $passenger['title'] : ''); ?>

                                                    <?php echo e($passenger['givenName'] ?? ''); ?>

                                                    <?php echo e($passenger['surname'] ?? ''); ?></li>
                                                <li class="list-group-item"><strong>Birthdate:</strong>
                                                    <?php echo e(isset($passenger['birthdate']) ? \Carbon\Carbon::parse($passenger['birthdate'])->format('d M Y') : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Gender:</strong>
                                                    <?php echo e($passenger['gender'] ?? 'N/A'); ?></li>
                                                <li class="list-group-item"><strong>Contact Ref:</strong>
                                                    <?php echo e($passenger['contactRef'] ?? 'N/A'); ?></li>
                                            </ul>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning">No passenger information available.</div>
                <?php endif; ?>

                <!-- Flight Segments -->
                <?php if($xmlBody && isset($xmlBody['segments']) && !empty($xmlBody['segments'])): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="segmentsHeading">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#segments" aria-expanded="false" aria-controls="segments">
                                Flight Segments
                            </button>
                        </h2>
                        <div id="segments" class="accordion-collapse collapse" aria-labelledby="segmentsHeading"
                            data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <?php $__currentLoopData = $xmlBody['segments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="card mb-3">
                                        <div class="card-header">
                                            Segment: <?php echo e($segment['departureCode'] ?? 'N/A'); ?> to
                                            <?php echo e($segment['arrivalCode'] ?? 'N/A'); ?>

                                        </div>
                                        <div class="card-body">
                                            <h6>Flight Details</h6>
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><strong>Departure:</strong>
                                                    <?php echo e($segment['flights']['Departure']['AirportName']['value'] ?? 'N/A'); ?>

                                                    (<?php echo e($segment['flights']['Departure']['AirportCode']['value'] ?? 'N/A'); ?>)
                                                    on
                                                    <?php echo e(isset($segment['flights']['Departure']['Date']['value']) ? \Carbon\Carbon::parse($segment['flights']['Departure']['Date']['value'])->format('d M Y') : 'N/A'); ?>

                                                    at <?php echo e($segment['flights']['Departure']['Time']['value'] ?? 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Arrival:</strong>
                                                    <?php echo e($segment['flights']['Arrival']['AirportName']['value'] ?? 'N/A'); ?>

                                                    (<?php echo e($segment['flights']['Arrival']['AirportCode']['value'] ?? 'N/A'); ?>)
                                                    on
                                                    <?php echo e(isset($segment['flights']['Arrival']['Date']['value']) ? \Carbon\Carbon::parse($segment['flights']['Arrival']['Date']['value'])->format('d M Y') : 'N/A'); ?>

                                                    at <?php echo e($segment['flights']['Arrival']['Time']['value'] ?? 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Duration:</strong>
                                                    <?php echo e($segment['duration'] ?? 'N/A'); ?></li>
                                                <li class="list-group-item"><strong>Price:</strong>
                                                    <?php echo e(isset($segment['price']) ? $segment['price']['code'] . ' ' . number_format($segment['price']['amount'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Aircraft:</strong>
                                                    <?php echo e($segment['flights']['equipment']['Name']['value'] ?? 'N/A'); ?>

                                                    (<?php echo e($segment['flights']['equipment']['AircraftCode']['value'] ?? 'N/A'); ?>)
                                                </li>
                                                <li class="list-group-item"><strong>Carrier:</strong>
                                                    <?php echo e($segment['flights']['marketingCarrier']['Name']['value'] ?? 'N/A'); ?>

                                                    (Flight
                                                    <?php echo e($segment['flights']['marketingCarrier']['FlightNumber']['value'] ?? 'N/A'); ?>)
                                                </li>
                                            </ul>
                                            <?php if(isset($segment['flights']['secondFlight'])): ?>
                                                <h6 class="mt-3">Connecting Flight</h6>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Departure:</strong>
                                                        <?php echo e($segment['flights']['secondFlight']['departure']['AirportName']['value'] ?? 'N/A'); ?>

                                                        (<?php echo e($segment['flights']['secondFlight']['departure']['AirportCode']['value'] ?? 'N/A'); ?>)
                                                        on
                                                        <?php echo e(isset($segment['flights']['secondFlight']['departure']['Date']['value']) ? \Carbon\Carbon::parse($segment['flights']['secondFlight']['departure']['Date']['value'])->format('d M Y') : 'N/A'); ?>

                                                        at
                                                        <?php echo e($segment['flights']['secondFlight']['departure']['Time']['value'] ?? 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Arrival:</strong>
                                                        <?php echo e($segment['flights']['secondFlight']['arrival']['AirportName']['value'] ?? 'N/A'); ?>

                                                        (<?php echo e($segment['flights']['secondFlight']['arrival']['AirportCode']['value'] ?? 'N/A'); ?>)
                                                        on
                                                        <?php echo e(isset($segment['flights']['secondFlight']['arrival']['Date']['value']) ? \Carbon\Carbon::parse($segment['flights']['secondFlight']['arrival']['Date']['value'])->format('d M Y') : 'N/A'); ?>

                                                        at
                                                        <?php echo e($segment['flights']['secondFlight']['arrival']['Time']['value'] ?? 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Aircraft:</strong>
                                                        <?php echo e($segment['flights']['secondFlight']['equipment']['Name']['value'] ?? 'N/A'); ?>

                                                        (<?php echo e($segment['flights']['secondFlight']['equipment']['AircraftCode']['value'] ?? 'N/A'); ?>)
                                                    </li>
                                                    <li class="list-group-item"><strong>Carrier:</strong>
                                                        <?php echo e($segment['flights']['secondFlight']['marketingCarrier']['Name']['value'] ?? 'N/A'); ?>

                                                        (Flight
                                                        <?php echo e($segment['flights']['secondFlight']['marketingCarrier']['FlightNumber']['value'] ?? 'N/A'); ?>)
                                                    </li>
                                                </ul>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning">No flight segments available.</div>
                <?php endif; ?>

                <!-- Pricing Information -->
                <?php if($xmlBody && isset($xmlBody['ticketInfos']) && !empty($xmlBody['ticketInfos'])): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="pricingInfoHeading">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#pricingInfo" aria-expanded="false" aria-controls="pricingInfo">
                                Pricing Information
                            </button>
                        </h2>
                        <div id="pricingInfo" class="accordion-collapse collapse" aria-labelledby="pricingInfoHeading"
                            data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <?php $__currentLoopData = $xmlBody['ticketInfos']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="card mb-3">
                                        <div class="card-header">
                                            Ticket for Passenger <?php echo e($ticket['passengerReference'] ?? 'N/A'); ?>

                                        </div>
                                        <div class="card-body">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><strong>Ticket Number:</strong>
                                                    <?php echo e($ticket['ticketDocument']['ticketDocNbr'] ?? 'N/A'); ?></li>
                                                <li class="list-group-item"><strong>Base Fare:</strong>
                                                    <?php echo e(isset($ticket['price']['details']['amount']) ? $ticket['price']['details']['amount']['code'] . ' ' . number_format($ticket['price']['details']['amount']['value'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Total Price:</strong>
                                                    <?php echo e(isset($ticket['price']['total']) ? $ticket['price']['total']['code'] . ' ' . number_format($ticket['price']['total']['value'], 2) : 'N/A'); ?>

                                                </li>
                                            </ul>
                                            <?php if(isset($ticket['price']['details']['taxes']['breakdown']) &&
                                                    !empty($ticket['price']['details']['taxes']['breakdown'])): ?>
                                                <h6 class="mt-3">Tax Breakdown</h6>
                                                <ul class="list-group list-group-flush">
                                                    <?php $__currentLoopData = $ticket['price']['details']['taxes']['breakdown']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li class="list-group-item">
                                                            <?php echo e($tax['description'] ?? 'Unknown Tax'); ?>:
                                                            <?php echo e(isset($tax['amount']) ? $tax['amount']['code'] . ' ' . number_format($tax['amount']['value'], 2) : 'N/A'); ?>

                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php else: ?>
                                                <p>No tax breakdown available.</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning">No pricing information available.</div>
                <?php endif; ?>

                <!-- Penalties -->
                <?php if($xmlBody && isset($xmlBody['bundle']['offerItem']) && !empty($xmlBody['bundle']['offerItem'])): ?>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="penaltiesHeading">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#penalties" aria-expanded="false" aria-controls="penalties">
                                Penalties
                            </button>
                        </h2>
                        <div id="penalties" class="accordion-collapse collapse" aria-labelledby="penaltiesHeading"
                            data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <?php $__currentLoopData = $xmlBody['bundle']['offerItem']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(isset($offer['fareDetail']['penalties']) && !empty($offer['fareDetail']['penalties'])): ?>
                                        <?php $__currentLoopData = $offer['fareDetail']['penalties']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penalty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="card mb-3">
                                                <div class="card-header">
                                                    <?php echo e($penalty['arrival'] ?? 'N/A'); ?> to
                                                    <?php echo e($penalty['destination'] ?? 'N/A'); ?>

                                                    (<?php echo e($penalty['cabinType'] ?? 'N/A'); ?>)
                                                </div>
                                                <div class="card-body">
                                                    <h6>Cancellation Fees</h6>
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item"><strong>Prior to
                                                                Departure:</strong>
                                                            <?php echo e(isset($penalty['fareRules']['cancelFee']['Prior to Departure']['price']) ? $penalty['fareRules']['cancelFee']['Prior to Departure']['price']['code'] . ' ' . number_format($penalty['fareRules']['cancelFee']['Prior to Departure']['price']['amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>No Show:</strong>
                                                            <?php echo e(isset($penalty['fareRules']['cancelFee']['No Show']['price']) ? $penalty['fareRules']['cancelFee']['No Show']['price']['code'] . ' ' . number_format($penalty['fareRules']['cancelFee']['No Show']['price']['amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                    </ul>
                                                    <h6>Change Fees</h6>
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item"><strong>Prior to
                                                                Departure:</strong>
                                                            <?php echo e(isset($penalty['fareRules']['changeFee']['Prior to Departure']['price']) ? $penalty['fareRules']['changeFee']['Prior to Departure']['price']['code'] . ' ' . number_format($penalty['fareRules']['changeFee']['Prior to Departure']['price']['amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>After Departure:</strong>
                                                            <?php echo e(isset($penalty['fareRules']['changeFee']['After Departure']['price']) ? $penalty['fareRules']['changeFee']['After Departure']['price']['code'] . ' ' . number_format($penalty['fareRules']['changeFee']['After Departure']['price']['amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>No Show:</strong>
                                                            <?php echo e(isset($penalty['fareRules']['changeFee']['No Show']['price']) ? $penalty['fareRules']['changeFee']['No Show']['price']['code'] . ' ' . number_format($penalty['fareRules']['changeFee']['No Show']['price']['amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                    </ul>
                                                    <h6>Refund Status</h6>
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item"><strong>Status:</strong>
                                                            <?php echo e($penalty['fareRules']['refundFee']['Status'] ?? 'N/A'); ?>

                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <p>No penalties available for this offer.</p>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="alert alert-warning">No penalties information available.</div>
                <?php endif; ?>
            </div>
        <?php elseif($airline === 'flyjinnah'): ?>
            <?php
                $airReservation = !empty($xmlBody['response']['Body']['OTA_AirBookRS']['AirReservation'])
                    ? $xmlBody['response']['Body']['OTA_AirBookRS']['AirReservation']
                    : (!empty($xmlBody['Body']['OTA_AirBookRS']['AirReservation'])
                        ? $xmlBody['Body']['OTA_AirBookRS']['AirReservation']
                        : null);
            ?>
            <?php if($bookingRequest && (is_array($xmlBody) || is_array($airReservation))): ?>
                <div class="accordion" id="bookingAccordion">
                    <!-- General Booking Information -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="generalInfoHeading">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#generalInfo" aria-expanded="true" aria-controls="generalInfo">
                                General Booking Information
                            </button>
                        </h2>
                        <div id="generalInfo" class="accordion-collapse collapse show"
                            aria-labelledby="generalInfoHeading" data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><strong>ID:</strong>
                                        <?php echo e($bookingRequest->id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Airline:</strong>
                                        <?php echo e($bookingRequest->airline ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Ticket Limit:</strong>
                                        <?php echo e(!empty($bookingRequest->ticket_limit) ? \Carbon\Carbon::parse($bookingRequest->ticket_limit)->format('d M Y, H:i') : (!empty($airReservation['Ticketing']['@attributes']['TicketTimeLimit']) ? \Carbon\Carbon::parse($airReservation['Ticketing']['@attributes']['TicketTimeLimit'])->format('d M Y, H:i') : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Payment Limit:</strong>
                                        <?php echo e(!empty($bookingRequest->payment_limit) ? \Carbon\Carbon::parse($bookingRequest->payment_limit)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Status:</strong>
                                        <?php echo e(!empty($bookingRequest->status) ? ucfirst($bookingRequest->status) : (!empty($airReservation['Ticketing']['TicketAdvisory']) ? $airReservation['Ticketing']['TicketAdvisory'] : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Client ID:</strong>
                                        <?php echo e($bookingRequest->client_id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Booking ID:</strong>
                                        <?php echo e($bookingRequest->booking_id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Transaction ID:</strong>
                                        <?php echo e(!empty($xmlBody['transactionId']) ? $xmlBody['transactionId'] : (!empty($xmlBody['Body']['OTA_AirBookRS']['@attributes']['TransactionIdentifier']) ? $xmlBody['Body']['OTA_AirBookRS']['@attributes']['TransactionIdentifier'] : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Total Amount:</strong>
                                        <?php echo e(!empty($xmlBody['code']) && !empty($xmlBody['amount']) ? $xmlBody['code'] . ' ' . number_format($xmlBody['amount'], 2) : (!empty($airReservation['PriceInfo']['ItinTotalFare']['TotalFare']['@attributes']['CurrencyCode']) && !empty($airReservation['PriceInfo']['ItinTotalFare']['TotalFare']['@attributes']['Amount']) ? $airReservation['PriceInfo']['ItinTotalFare']['TotalFare']['@attributes']['CurrencyCode'] . ' ' . number_format($airReservation['PriceInfo']['ItinTotalFare']['TotalFare']['@attributes']['Amount'], 2) : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Message:</strong>
                                        <?php echo e(!empty($xmlBody['message']) ? $xmlBody['message'] : (!empty($airReservation['Ticketing']['TicketAdvisory']) ? $airReservation['Ticketing']['TicketAdvisory'] : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Booking Reference:</strong>
                                        <?php echo e(!empty($airReservation['BookingReferenceID']['@attributes']['ID']) ? $airReservation['BookingReferenceID']['@attributes']['ID'] : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Created At:</strong>
                                        <?php echo e(!empty($bookingRequest->created_at) ? \Carbon\Carbon::parse($bookingRequest->created_at)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Updated At:</strong>
                                        <?php echo e(!empty($bookingRequest->updated_at) ? \Carbon\Carbon::parse($bookingRequest->updated_at)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Passenger Information -->
                    <?php if(!empty($xmlBody['passengers']) && is_array($xmlBody['passengers'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="passengerInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#passengerInfo" aria-expanded="false"
                                    aria-controls="passengerInfo">
                                    Passenger Information
                                </button>
                            </h2>
                            <div id="passengerInfo" class="accordion-collapse collapse"
                                aria-labelledby="passengerInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(is_array($passenger)): ?>
                                            <div class="card mb-3">
                                                <div class="card-header">
                                                    Passenger
                                                    <?php echo e(!empty($passenger['ref_no']) ? $passenger['ref_no'] : 'Unknown'); ?>

                                                    (<?php echo e(!empty($passenger['passenger_type']) ? $passenger['passenger_type'] : 'N/A'); ?>)
                                                </div>
                                                <div class="card-body">
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item"><strong>Name:</strong>
                                                            <?php echo e(!empty($passenger['name']) ? $passenger['name'] : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Nationality:</strong>
                                                            <?php echo e(!empty($passenger['nationality']) ? $passenger['nationality'] : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Phone Number:</strong>
                                                            <?php echo e(!empty($passenger['phone_number']) ? $passenger['phone_number'] : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Reference Number:</strong>
                                                            <?php echo e(!empty($passenger['ref_no']) ? $passenger['ref_no'] : 'N/A'); ?>

                                                        </li>
                                                    </ul>
                                                    <!-- Seats -->
                                                    <?php if(!empty($passenger['seats']) && is_array($passenger['seats'])): ?>
                                                        <h6 class="mt-3">Seats</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $passenger['seats']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(is_array($seat)): ?>
                                                                    <li class="list-group-item">
                                                                        <strong>Seat:</strong>
                                                                        <?php echo e(!empty($seat['seat_number']) ? $seat['seat_number'] : 'N/A'); ?>

                                                                        (Flight
                                                                        <?php echo e(!empty($seat['flight_number']) ? $seat['flight_number'] : 'N/A'); ?>,
                                                                        <?php echo e(!empty($seat['departure_date']) ? \Carbon\Carbon::parse($seat['departure_date'])->format('d M Y, H:i') : 'N/A'); ?>)
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php else: ?>
                                                        <p>No seat information available.</p>
                                                    <?php endif; ?>
                                                    <!-- Baggage -->
                                                    <?php if(!empty($passenger['baggage']) && is_array($passenger['baggage'])): ?>
                                                        <h6 class="mt-3">Baggage</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $passenger['baggage']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $baggage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(is_array($baggage)): ?>
                                                                    <li class="list-group-item">
                                                                        <strong>Baggage:</strong>
                                                                        <?php echo e(!empty($baggage['baggage_code']) ? $baggage['baggage_code'] : 'N/A'); ?>

                                                                        (Flight
                                                                        <?php echo e(!empty($baggage['flight_number']) ? $baggage['flight_number'] : 'N/A'); ?>,
                                                                        <?php echo e(!empty($baggage['departure_date']) ? \Carbon\Carbon::parse($baggage['departure_date'])->format('d M Y, H:i') : 'N/A'); ?>)
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php else: ?>
                                                        <p>No baggage information available.</p>
                                                    <?php endif; ?>
                                                    <!-- Meals -->
                                                    <?php if(!empty($passenger['meals']) && is_array($passenger['meals'])): ?>
                                                        <h6 class="mt-3">Meals</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $passenger['meals']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $meal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(is_array($meal)): ?>
                                                                    <li class="list-group-item">
                                                                        <strong>Meal:</strong>
                                                                        <?php echo e(!empty($meal['meal_code']) ? $meal['meal_code'] : 'N/A'); ?>

                                                                        (Quantity:
                                                                        <?php echo e(!empty($meal['meal_quantity']) ? $meal['meal_quantity'] : 'N/A'); ?>,
                                                                        Flight
                                                                        <?php echo e(!empty($meal['flight_number']) ? $meal['flight_number'] : 'N/A'); ?>,
                                                                        <?php echo e(!empty($meal['departure_date']) ? \Carbon\Carbon::parse($meal['departure_date'])->format('d M Y, H:i') : 'N/A'); ?>)
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php else: ?>
                                                        <p>No meal information available.</p>
                                                    <?php endif; ?>
                                                    <!-- Tickets -->
                                                    <?php if(!empty($passenger['tickets']) && is_array($passenger['tickets'])): ?>
                                                        <h6 class="mt-3">Tickets</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $passenger['tickets']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(is_array($ticket)): ?>
                                                                    <li class="list-group-item">
                                                                        <strong>Ticket:</strong>
                                                                        <?php echo e(!empty($ticket['e_ticket_no']) ? $ticket['e_ticket_no'] : 'N/A'); ?>

                                                                        (Coupon:
                                                                        <?php echo e(!empty($ticket['coupon_no']) ? $ticket['coupon_no'] : 'N/A'); ?>,
                                                                        Segment:
                                                                        <?php echo e(!empty($ticket['flight_segment']) ? $ticket['flight_segment'] : 'N/A'); ?>,
                                                                        Status:
                                                                        <?php echo e(!empty($ticket['status']) ? $ticket['status'] : 'N/A'); ?>)
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php else: ?>
                                                        <p>No ticket information available.</p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php elseif(!empty($airReservation['TravelerInfo']['AirTraveler'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="passengerInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#passengerInfo" aria-expanded="false"
                                    aria-controls="passengerInfo">
                                    Passenger Information
                                </button>
                            </h2>
                            <div id="passengerInfo" class="accordion-collapse collapse"
                                aria-labelledby="passengerInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php
                                        // Normalize AirTraveler to always be an array
                                        $travelers =
                                            is_array($airReservation['TravelerInfo']['AirTraveler']) &&
                                            isset($airReservation['TravelerInfo']['AirTraveler'][0])
                                                ? $airReservation['TravelerInfo']['AirTraveler']
                                                : [$airReservation['TravelerInfo']['AirTraveler']];
                                    ?>
                                    <?php $__currentLoopData = $travelers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $traveler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(is_array($traveler)): ?>
                                            <div class="card mb-3">
                                                <div class="card-header">
                                                    Passenger
                                                    <?php echo e(!empty($traveler['TravelerRefNumber']['@attributes']['RPH']) ? $traveler['TravelerRefNumber']['@attributes']['RPH'] : 'Unknown'); ?>

                                                    (<?php echo e(!empty($traveler['@attributes']['PassengerTypeCode']) ? $traveler['@attributes']['PassengerTypeCode'] : 'N/A'); ?>)
                                                </div>
                                                <div class="card-body">
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item"><strong>Name:</strong>
                                                            <?php echo e(!empty($traveler['PersonName']['GivenName']) && !empty($traveler['PersonName']['Surname']) ? $traveler['PersonName']['GivenName'] . ' ' . $traveler['PersonName']['Surname'] : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Nationality:</strong>
                                                            <?php echo e(!empty($traveler['Document']['@attributes']['DocHolderNationality']) ? $traveler['Document']['@attributes']['DocHolderNationality'] : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Phone Number:</strong>
                                                            <?php echo e(!empty($traveler['Telephone']['@attributes']['PhoneNumber']) ? $traveler['Telephone']['@attributes']['PhoneNumber'] : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Reference Number:</strong>
                                                            <?php echo e(!empty($traveler['TravelerRefNumber']['@attributes']['RPH']) ? $traveler['TravelerRefNumber']['@attributes']['RPH'] : 'N/A'); ?>

                                                        </li>
                                                    </ul>
                                                    <!-- Tickets -->
                                                    <?php if(
                                                        !empty($traveler['ETicketInfo']) &&
                                                            is_array($traveler['ETicketInfo']) &&
                                                            !empty($traveler['ETicketInfo']['ETicketInformation']) &&
                                                            is_array($traveler['ETicketInfo']['ETicketInformation'])): ?>
                                                        <h6 class="mt-3">Tickets</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $traveler['ETicketInfo']['ETicketInformation']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(is_array($ticket)): ?>
                                                                    <li class="list-group-item">
                                                                        <strong>Ticket:</strong>
                                                                        <?php echo e(!empty($ticket['@attributes']['eTicketNo']) ? $ticket['@attributes']['eTicketNo'] : 'N/A'); ?>

                                                                        (Coupon:
                                                                        <?php echo e(!empty($ticket['@attributes']['couponNo']) ? $ticket['@attributes']['couponNo'] : 'N/A'); ?>,
                                                                        Segment:
                                                                        <?php echo e(!empty($ticket['@attributes']['flightSegmentCode']) ? $ticket['@attributes']['flightSegmentCode'] : 'N/A'); ?>,
                                                                        Status:
                                                                        <?php echo e(!empty($ticket['@attributes']['status']) ? $ticket['@attributes']['status'] : 'N/A'); ?>)
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php else: ?>
                                                        <p>No ticket information available.</p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No passenger information available.</div>
                    <?php endif; ?>

                    <!-- Flight Segments -->
                    <?php if(
                        !empty($airReservation['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']) &&
                            is_array($airReservation['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="segmentsHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#segments" aria-expanded="false" aria-controls="segments">
                                    Flight Segments
                                </button>
                            </h2>
                            <div id="segments" class="accordion-collapse collapse" aria-labelledby="segmentsHeading"
                                data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php
                                        $options =
                                            $airReservation['AirItinerary']['OriginDestinationOptions'][
                                                'OriginDestinationOption'
                                            ];
                                        $options = is_array($options) && isset($options[0]) ? $options : [$options];
                                    ?>
                                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($option['FlightSegment']) && is_array($option['FlightSegment'])): ?>
                                            <?php $__currentLoopData = $option['FlightSegment']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(is_array($segment)): ?>
                                                    <div class="card mb-3">
                                                        <div class="card-header">
                                                            Segment:
                                                            <?php echo e(!empty($segment['DepartureAirport']['@attributes']['LocationCode']) ? $segment['DepartureAirport']['@attributes']['LocationCode'] : 'N/A'); ?>

                                                            to
                                                            <?php echo e(!empty($segment['ArrivalAirport']['@attributes']['LocationCode']) ? $segment['ArrivalAirport']['@attributes']['LocationCode'] : 'N/A'); ?>

                                                        </div>
                                                        <div class="card-body">
                                                            <h6>Flight Details</h6>
                                                            <ul class="list-group list-group-flush">
                                                                <li class="list-group-item"><strong>Departure:</strong>
                                                                    <?php echo e(!empty($segment['Comment']) ? str_replace('airport_short_names:', '', $segment['Comment']) : 'N/A'); ?>

                                                                    (<?php echo e(!empty($segment['DepartureAirport']['@attributes']['LocationCode']) ? $segment['DepartureAirport']['@attributes']['LocationCode'] : 'N/A'); ?>)
                                                                    on
                                                                    <?php echo e(!empty($segment['@attributes']['DepartureDateTime']) ? \Carbon\Carbon::parse($segment['@attributes']['DepartureDateTime'])->format('d M Y') : 'N/A'); ?>

                                                                    at
                                                                    <?php echo e(!empty($segment['@attributes']['DepartureDateTime']) ? \Carbon\Carbon::parse($segment['@attributes']['DepartureDateTime'])->format('H:i') : 'N/A'); ?>

                                                                </li>
                                                                <li class="list-group-item"><strong>Arrival:</strong>
                                                                    <?php echo e(!empty($segment['Comment']) ? str_replace('airport_short_names:', '', $segment['Comment']) : 'N/A'); ?>

                                                                    (<?php echo e(!empty($segment['ArrivalAirport']['@attributes']['LocationCode']) ? $segment['ArrivalAirport']['@attributes']['LocationCode'] : 'N/A'); ?>)
                                                                    on
                                                                    <?php echo e(!empty($segment['@attributes']['ArrivalDateTime']) ? \Carbon\Carbon::parse($segment['@attributes']['ArrivalDateTime'])->format('d M Y') : 'N/A'); ?>

                                                                    at
                                                                    <?php echo e(!empty($segment['@attributes']['ArrivalDateTime']) ? \Carbon\Carbon::parse($segment['@attributes']['ArrivalDateTime'])->format('H:i') : 'N/A'); ?>

                                                                </li>
                                                                <li class="list-group-item"><strong>Terminal:</strong>
                                                                    Departure -
                                                                    <?php echo e(!empty($segment['DepartureAirport']['@attributes']['Terminal']) ? $segment['DepartureAirport']['@attributes']['Terminal'] : 'N/A'); ?>,
                                                                    Arrival -
                                                                    <?php echo e(!empty($segment['ArrivalAirport']['@attributes']['Terminal']) ? $segment['ArrivalAirport']['@attributes']['Terminal'] : 'N/A'); ?>

                                                                </li>
                                                                <li class="list-group-item"><strong>Duration:</strong>
                                                                    <?php echo e(!empty($segment['@attributes']['DepartureDateTime']) && !empty($segment['@attributes']['ArrivalDateTime']) ? \Carbon\Carbon::parse($segment['@attributes']['DepartureDateTime'])->diffInMinutes(\Carbon\Carbon::parse($segment['@attributes']['ArrivalDateTime'])) . ' minutes' : 'N/A'); ?>

                                                                </li>
                                                                <li class="list-group-item"><strong>Flight
                                                                        Number:</strong>
                                                                    <?php echo e(!empty($segment['@attributes']['FlightNumber']) ? $segment['@attributes']['FlightNumber'] : 'N/A'); ?>

                                                                </li>
                                                                <li class="list-group-item"><strong>Cabin
                                                                        Class:</strong>
                                                                    <?php echo e(!empty($segment['@attributes']['ResCabinClass']) ? $segment['@attributes']['ResCabinClass'] : 'N/A'); ?>

                                                                </li>
                                                                <li class="list-group-item"><strong>Status:</strong>
                                                                    <?php echo e(!empty($segment['@attributes']['Status']) ? $segment['@attributes']['Status'] : 'N/A'); ?>

                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No flight segments available.</div>
                    <?php endif; ?>

                    <!-- Pricing Information -->
                    <?php if(!empty($airReservation['PriceInfo']['ItinTotalFare']) && is_array($airReservation['PriceInfo']['ItinTotalFare'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="pricingInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#pricingInfo" aria-expanded="false" aria-controls="pricingInfo">
                                    Pricing Information
                                </button>
                            </h2>
                            <div id="pricingInfo" class="accordion-collapse collapse"
                                aria-labelledby="pricingInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php
                                        $priceInfo = $airReservation['PriceInfo']['ItinTotalFare'];
                                    ?>
                                    <div class="card mb-3">
                                        <div class="card-header">
                                            Pricing Details
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><strong>Base Fare:</strong>
                                                    <?php echo e(!empty($priceInfo['BaseFare']['@attributes']['CurrencyCode']) && !empty($priceInfo['BaseFare']['@attributes']['Amount']) ? $priceInfo['BaseFare']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['BaseFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Equivalent Base Fare:</strong>
                                                    <?php echo e(!empty($priceInfo['EquiBaseFare']['@attributes']['CurrencyCode']) && !empty($priceInfo['EquiBaseFare']['@attributes']['Amount']) ? $priceInfo['EquiBaseFare']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['EquiBaseFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Taxes:</strong>
                                                    <?php echo e(!empty($priceInfo['Taxes']['Tax']['@attributes']['CurrencyCode']) && !empty($priceInfo['Taxes']['Tax']['@attributes']['Amount']) ? $priceInfo['Taxes']['Tax']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['Taxes']['Tax']['@attributes']['Amount'], 2) . ' (' . $priceInfo['Taxes']['Tax']['@attributes']['TaxCode'] . ')' : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Fees:</strong>
                                                    <?php echo e(!empty($priceInfo['Fees']['Fee']['@attributes']['CurrencyCode']) && !empty($priceInfo['Fees']['Fee']['@attributes']['Amount']) ? $priceInfo['Fees']['Fee']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['Fees']['Fee']['@attributes']['Amount'], 2) . ' (' . $priceInfo['Fees']['Fee']['@attributes']['FeeCode'] . ')' : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Total Fare:</strong>
                                                    <?php echo e(!empty($priceInfo['TotalFare']['@attributes']['CurrencyCode']) && !empty($priceInfo['TotalFare']['@attributes']['Amount']) ? $priceInfo['TotalFare']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['TotalFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Equivalent Total Fare:</strong>
                                                    <?php echo e(!empty($priceInfo['TotalEquivFare']['@attributes']['CurrencyCode']) && !empty($priceInfo['TotalEquivFare']['@attributes']['Amount']) ? $priceInfo['TotalEquivFare']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['TotalEquivFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Total Fare with CC Fee:</strong>
                                                    <?php echo e(!empty($priceInfo['TotalFareWithCCFee']['@attributes']['CurrencyCode']) && !empty($priceInfo['TotalFareWithCCFee']['@attributes']['Amount']) ? $priceInfo['TotalFareWithCCFee']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['TotalFareWithCCFee']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                </li>
                                                <li class="list-group-item"><strong>Equivalent Total Fare with CC
                                                        Fee:</strong>
                                                    <?php echo e(!empty($priceInfo['TotalEquivFareWithCCFee']['@attributes']['CurrencyCode']) && !empty($priceInfo['TotalEquivFareWithCCFee']['@attributes']['Amount']) ? $priceInfo['TotalEquivFareWithCCFee']['@attributes']['CurrencyCode'] . ' ' . number_format($priceInfo['TotalEquivFareWithCCFee']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                </li>
                                            </ul>
                                            <!-- Detailed Tax Breakdown -->
                                            <?php if(
                                                !empty($airReservation['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown']) &&
                                                    is_array($airReservation['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'])): ?>
                                                <?php
                                                    $ptcFare =
                                                        is_array(
                                                            $airReservation['PriceInfo']['PTC_FareBreakdowns'][
                                                                'PTC_FareBreakdown'
                                                            ],
                                                        ) &&
                                                        isset(
                                                            $airReservation['PriceInfo']['PTC_FareBreakdowns'][
                                                                'PTC_FareBreakdown'
                                                            ][0],
                                                        )
                                                            ? $airReservation['PriceInfo']['PTC_FareBreakdowns'][
                                                                'PTC_FareBreakdown'
                                                            ]
                                                            : [
                                                                $airReservation['PriceInfo']['PTC_FareBreakdowns'][
                                                                    'PTC_FareBreakdown'
                                                                ],
                                                            ];
                                                ?>
                                                <h6 class="mt-3">Fare Breakdown</h6>
                                                <?php $__currentLoopData = $ptcFare; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fare): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(is_array($fare) && !empty($fare['PassengerTypeQuantity']['@attributes'])): ?>
                                                        <div class="card mb-3">
                                                            <div class="card-header">
                                                                Passenger Type:
                                                                <?php echo e(!empty($fare['PassengerTypeQuantity']['@attributes']['Code']) ? $fare['PassengerTypeQuantity']['@attributes']['Code'] : 'N/A'); ?>

                                                                (Quantity:
                                                                <?php echo e(!empty($fare['PassengerTypeQuantity']['@attributes']['Quantity']) ? $fare['PassengerTypeQuantity']['@attributes']['Quantity'] : 'N/A'); ?>)
                                                            </div>
                                                            <div class="card-body">
                                                                <ul class="list-group list-group-flush">
                                                                    <li class="list-group-item"><strong>Fare Basis
                                                                            Code:</strong>
                                                                        <?php echo e(!empty($fare['FareBasisCodes']['FareBasisCode']) ? $fare['FareBasisCodes']['FareBasisCode'] : 'N/A'); ?>

                                                                    </li>
                                                                    <li class="list-group-item"><strong>Base
                                                                            Fare:</strong>
                                                                        <?php echo e(!empty($fare['PassengerFare']['BaseFare']['@attributes']['CurrencyCode']) && !empty($fare['PassengerFare']['BaseFare']['@attributes']['Amount']) ? $fare['PassengerFare']['BaseFare']['@attributes']['CurrencyCode'] . ' ' . number_format($fare['PassengerFare']['BaseFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                    </li>
                                                                    <li class="list-group-item"><strong>Equivalent Base
                                                                            Fare:</strong>
                                                                        <?php echo e(!empty($fare['PassengerFare']['EquiBaseFare']['@attributes']['CurrencyCode']) && !empty($fare['PassengerFare']['EquiBaseFare']['@attributes']['Amount']) ? $fare['PassengerFare']['EquiBaseFare']['@attributes']['CurrencyCode'] . ' ' . number_format($fare['PassengerFare']['EquiBaseFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                    </li>
                                                                    <li class="list-group-item"><strong>Total
                                                                            Fare:</strong>
                                                                        <?php echo e(!empty($fare['PassengerFare']['TotalFare']['@attributes']['CurrencyCode']) && !empty($fare['PassengerFare']['TotalFare']['@attributes']['Amount']) ? $fare['PassengerFare']['TotalFare']['@attributes']['CurrencyCode'] . ' ' . number_format($fare['PassengerFare']['TotalFare']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                    </li>
                                                                </ul>
                                                                <?php if(!empty($fare['PassengerFare']['Taxes']['Tax']) && is_array($fare['PassengerFare']['Taxes']['Tax'])): ?>
                                                                    <h6 class="mt-3">Taxes</h6>
                                                                    <ul class="list-group list-group-flush">
                                                                        <?php $__currentLoopData = $fare['PassengerFare']['Taxes']['Tax']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php if(is_array($tax)): ?>
                                                                                <li class="list-group-item">
                                                                                    <strong><?php echo e(!empty($tax['@attributes']['TaxName']) ? $tax['@attributes']['TaxName'] : 'Tax'); ?>:</strong>
                                                                                    <?php echo e(!empty($tax['@attributes']['CurrencyCode']) && !empty($tax['@attributes']['Amount']) ? $tax['@attributes']['CurrencyCode'] . ' ' . number_format($tax['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                                    (<?php echo e(!empty($tax['@attributes']['TaxCode']) ? $tax['@attributes']['TaxCode'] : 'N/A'); ?>)
                                                                                </li>
                                                                            <?php endif; ?>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                                <?php if(!empty($fare['PassengerFare']['Fees']['Fee']) && is_array($fare['PassengerFare']['Fees']['Fee'])): ?>
                                                                    <h6 class="mt-3">Fees</h6>
                                                                    <ul class="list-group list-group-flush">
                                                                        <?php $__currentLoopData = $fare['PassengerFare']['Fees']['Fee']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="list-group-item">
                                                                                <strong>Fee:</strong>
                                                                                <?php echo e($fee); ?>

                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                            <!-- Payment Details -->
                                            <?php if(
                                                !empty($airReservation['Fulfillment']['PaymentDetails']['PaymentDetail']) &&
                                                    is_array($airReservation['Fulfillment']['PaymentDetails']['PaymentDetail'])): ?>
                                                <h6 class="mt-3">Payment Details</h6>
                                                <ul class="list-group list-group-flush">
                                                    <?php $__currentLoopData = $airReservation['Fulfillment']['PaymentDetails']['PaymentDetail']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(is_array($payment)): ?>
                                                            <li class="list-group-item">
                                                                <strong>Payment:</strong>
                                                                <?php echo e(!empty($payment['PaymentAmount']['@attributes']['CurrencyCode']) && !empty($payment['PaymentAmount']['@attributes']['Amount']) ? $payment['PaymentAmount']['@attributes']['CurrencyCode'] . ' ' . number_format($payment['PaymentAmount']['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                (<?php echo e(!empty($payment['PaymentAmountInPayCur']['@attributes']['CurrencyCode']) && !empty($payment['PaymentAmountInPayCur']['@attributes']['Amount']) ? $payment['PaymentAmountInPayCur']['@attributes']['CurrencyCode'] . ' ' . number_format($payment['PaymentAmountInPayCur']['@attributes']['Amount'], 2) : 'N/A'); ?>)
                                                                <?php if(!empty($payment['DirectBill']['CompanyName'])): ?>
                                                                    <br><strong>Company:</strong>
                                                                    <?php echo e($payment['DirectBill']['CompanyName']); ?>

                                                                <?php endif; ?>
                                                            </li>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            <?php else: ?>
                                                <p>No payment details available.</p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No pricing information available.</div>
                    <?php endif; ?>

                    <!-- Penalties -->
                    <?php if(
                        !empty($airReservation['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption']) &&
                            is_array($airReservation['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="penaltiesHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#penalties" aria-expanded="false" aria-controls="penalties">
                                    Penalties
                                </button>
                            </h2>
                            <div id="penalties" class="accordion-collapse collapse"
                                aria-labelledby="penaltiesHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php
                                        $hasPenalties = false;
                                        $options =
                                            $airReservation['AirItinerary']['OriginDestinationOptions'][
                                                'OriginDestinationOption'
                                            ];
                                        $options = is_array($options) && isset($options[0]) ? $options : [$options];
                                    ?>
                                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($option['FlightSegment']) && is_array($option['FlightSegment'])): ?>
                                            <?php $__currentLoopData = $option['FlightSegment']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(is_array($segment) &&
                                                        !empty($segment['AvailableFlexiOperations']['FlexiOperations']) &&
                                                        is_array($segment['AvailableFlexiOperations']['FlexiOperations'])): ?>
                                                    <?php $hasPenalties = true; ?>
                                                    <div class="card mb-3">
                                                        <div class="card-header">
                                                            Segment:
                                                            <?php echo e(!empty($segment['DepartureAirport']['@attributes']['LocationCode']) ? $segment['DepartureAirport']['@attributes']['LocationCode'] : 'N/A'); ?>

                                                            to
                                                            <?php echo e(!empty($segment['ArrivalAirport']['@attributes']['LocationCode']) ? $segment['ArrivalAirport']['@attributes']['LocationCode'] : 'N/A'); ?>

                                                        </div>
                                                        <div class="card-body">
                                                            <h6>Flexi Operations</h6>
                                                            <ul class="list-group list-group-flush">
                                                                <?php $__currentLoopData = $segment['AvailableFlexiOperations']['FlexiOperations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if(is_array($operation) && !empty($operation['@attributes'])): ?>
                                                                        <li class="list-group-item">
                                                                            <strong><?php echo e(!empty($operation['@attributes']['AllowedOperationName']) ? $operation['@attributes']['AllowedOperationName'] : 'N/A'); ?>:</strong>
                                                                            Allowed
                                                                            <?php echo e(!empty($operation['@attributes']['NumberOfAllowedOperations']) ? $operation['@attributes']['NumberOfAllowedOperations'] : 'N/A'); ?>

                                                                            time(s),
                                                                            Cutoff:
                                                                            <?php echo e(!empty($operation['@attributes']['FlexiOperationCutoverTimeInMinutes']) ? $operation['@attributes']['FlexiOperationCutoverTimeInMinutes'] . ' minutes' : 'N/A'); ?>

                                                                        </li>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!$hasPenalties): ?>
                                        <p>No penalty information available.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No penalties information available.</div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        <?php elseif($airline === 'pia'): ?>
            <?php if($bookingRequest && is_array($xmlBody)): ?>
                <div class="accordion" id="bookingAccordion">
                    <!-- General Booking Information -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="generalInfoHeading">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#generalInfo" aria-expanded="true" aria-controls="generalInfo">
                                General Booking Information PIA
                            </button>
                        </h2>
                        <div id="generalInfo" class="accordion-collapse collapse show"
                            aria-labelledby="generalInfoHeading" data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><strong>ID:</strong>
                                        <?php echo e($bookingRequest->id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Airline:</strong>
                                        <?php echo e($bookingRequest->airline ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Ticket Limit:</strong>
                                        <?php echo e(!empty($bookingRequest->ticket_limit) ? \Carbon\Carbon::parse($bookingRequest->ticket_limit)->format('d M Y, H:i') : (!empty($xmlBody['paymentLimit']) ? \Carbon\Carbon::parse($xmlBody['paymentLimit'])->format('d M Y, H:i') : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Payment Limit:</strong>
                                        <?php echo e(!empty($bookingRequest->payment_limit) ? \Carbon\Carbon::parse($bookingRequest->payment_limit)->format('d M Y, H:i') : (!empty($xmlBody['paymentLimit']) ? \Carbon\Carbon::parse($xmlBody['paymentLimit'])->format('d M Y, H:i') : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Status:</strong>
                                        <?php echo e(!empty($bookingRequest->status) ? ucfirst($bookingRequest->status) : (!empty($xmlBody['order']['statusCode']) ? $xmlBody['order']['statusCode'] : 'N/A')); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Client ID:</strong>
                                        <?php echo e($bookingRequest->client_id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Booking ID:</strong>
                                        <?php echo e($bookingRequest->booking_id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Transaction ID:</strong>
                                        <?php echo e(!empty($xmlBody['transaction_id']) ? $xmlBody['transaction_id'] : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Total Amount:</strong>
                                        <?php echo e(!empty($xmlBody['totalPrice']) ? 'PKR ' . number_format($xmlBody['totalPrice'], 2) : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Booking Reference:</strong>
                                        <?php echo e(!empty($xmlBody['order']['orderID']) ? $xmlBody['order']['orderID'] : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Created At:</strong>
                                        <?php echo e(!empty($bookingRequest->created_at) ? \Carbon\Carbon::parse($bookingRequest->created_at)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Updated At:</strong>
                                        <?php echo e(!empty($bookingRequest->updated_at) ? \Carbon\Carbon::parse($bookingRequest->updated_at)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- Passenger Information -->
                    <?php if(!empty($xmlBody['passengers']) && is_array($xmlBody['passengers'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="passengerInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#passengerInfo" aria-expanded="false"
                                    aria-controls="passengerInfo">
                                    Passenger Information
                                </button>
                            </h2>
                            <div id="passengerInfo" class="accordion-collapse collapse"
                                aria-labelledby="passengerInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Passenger
                                                <?php echo e(!empty($passenger['pax_id']) ? $passenger['pax_id'] : 'Unknown'); ?>

                                                (<?php echo e(!empty($passenger['ptc']) ? $passenger['ptc'] : 'N/A'); ?>)
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Name:</strong>
                                                        <?php echo e(!empty($passenger['title']) ? $passenger['title'] . ' ' : ''); ?><?php echo e(!empty($passenger['given_name']) ? $passenger['given_name'] : ''); ?>

                                                        <?php echo e(!empty($passenger['surname']) ? $passenger['surname'] : ''); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Birthdate:</strong>
                                                        <?php echo e(!empty($passenger['birthdate']) ? \Carbon\Carbon::parse($passenger['birthdate'])->format('d M Y') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Gender:</strong>
                                                        <?php echo e(!empty($passenger['gender']) ? $passenger['gender'] : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Citizenship:</strong>
                                                        <?php echo e(!empty($passenger['citizenship']) ? $passenger['citizenship'] : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Ticket Number:</strong>
                                                        <?php echo e(!empty($passenger['ticket']['ticketNumber']) ? $passenger['ticket']['ticketNumber'] : 'N/A'); ?>

                                                    </li>
                                                </ul>
                                                <!-- Services -->
                                                <?php if(!empty($passenger['services']) && is_array($passenger['services'])): ?>
                                                    <h6 class="mt-3">Services</h6>
                                                    <ul class="list-group list-group-flush">
                                                        <?php $__currentLoopData = $passenger['services']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li class="list-group-item">
                                                                <strong>Service:</strong>
                                                                <?php echo e(!empty($service['service_definition_id']) ? $service['service_definition_id'] : 'N/A'); ?>

                                                                (Status:
                                                                <?php echo e(!empty($service['status_code']) ? $service['status_code'] : 'N/A'); ?>)
                                                            </li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                <?php else: ?>
                                                    <p>No services information available.</p>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No passenger information available.</div>
                    <?php endif; ?>

                    <!-- Flight Segments -->
                    <?php if(!empty($xmlBody['segments']) && is_array($xmlBody['segments'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="segmentsHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#segments" aria-expanded="false" aria-controls="segments">
                                    Flight Segments
                                </button>
                            </h2>
                            <div id="segments" class="accordion-collapse collapse" aria-labelledby="segmentsHeading"
                                data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $xmlBody['segments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Segment: <?php echo e(!empty($segment['origin']) ? $segment['origin'] : 'N/A'); ?>

                                                to
                                                <?php echo e(!empty($segment['destination']) ? $segment['destination'] : 'N/A'); ?>

                                            </div>
                                            <div class="card-body">
                                                <h6>Flight Details</h6>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Departure:</strong>
                                                        <?php echo e(!empty($segment['origin_name']) ? $segment['origin_name'] : 'N/A'); ?>

                                                        (<?php echo e(!empty($segment['origin']) ? $segment['origin'] : 'N/A'); ?>)
                                                        on
                                                        <?php echo e(!empty($segment['departure_time']) ? \Carbon\Carbon::parse($segment['departure_time'])->format('d M Y, H:i') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Arrival:</strong>
                                                        <?php echo e(!empty($segment['destination_name']) ? $segment['destination_name'] : 'N/A'); ?>

                                                        (<?php echo e(!empty($segment['destination']) ? $segment['destination'] : 'N/A'); ?>)
                                                        on
                                                        <?php echo e(!empty($segment['arrival_time']) ? \Carbon\Carbon::parse($segment['arrival_time'])->format('d M Y, H:i') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Duration:</strong>
                                                        <?php echo e(!empty($segment['duration']) ? $segment['duration'] : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Flight Number:</strong>
                                                        <?php echo e(!empty($segment['flight_number']) ? $segment['flight_number'] : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Carrier:</strong>
                                                        <?php echo e(!empty($segment['carrier']) ? $segment['carrier'] : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Aircraft Type:</strong>
                                                        <?php echo e(!empty($segment['aircraft_type']) ? $segment['aircraft_type'] : 'N/A'); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No flight segments available.</div>
                    <?php endif; ?>

                    <!-- Pricing Information -->
                    <?php if(!empty($xmlBody['passengers']) && is_array($xmlBody['passengers'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="pricingInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#pricingInfo" aria-expanded="false" aria-controls="pricingInfo">
                                    Pricing Information
                                </button>
                            </h2>
                            <div id="pricingInfo" class="accordion-collapse collapse"
                                aria-labelledby="pricingInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($passenger['fare_details']['fare_price_type']['price'])): ?>
                                            <div class="card mb-3">
                                                <div class="card-header">
                                                    Pricing for Passenger
                                                    <?php echo e(!empty($passenger['pax_id']) ? $passenger['pax_id'] : 'Unknown'); ?>

                                                    (<?php echo e(!empty($passenger['ptc']) ? $passenger['ptc'] : 'N/A'); ?>)
                                                </div>
                                                <div class="card-body">
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item"><strong>Base Fare:</strong>
                                                            <?php echo e(!empty($passenger['fare_details']['fare_price_type']['price']['base_amount']) ? $passenger['fare_details']['fare_price_type']['price']['currency'] . ' ' . number_format($passenger['fare_details']['fare_price_type']['price']['base_amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Total Fare:</strong>
                                                            <?php echo e(!empty($passenger['fare_details']['fare_price_type']['price']['total_amount']) ? $passenger['fare_details']['fare_price_type']['price']['currency'] . ' ' . number_format($passenger['fare_details']['fare_price_type']['price']['total_amount'], 2) : 'N/A'); ?>

                                                        </li>
                                                        <li class="list-group-item"><strong>Surcharge:</strong>
                                                            <?php echo e(!empty($passenger['fare_details']['fare_price_type']['price']['surcharge']) ? $passenger['fare_details']['fare_price_type']['price']['currency'] . ' ' . number_format($passenger['fare_details']['fare_price_type']['price']['surcharge'], 2) : 'N/A'); ?>

                                                        </li>
                                                    </ul>
                                                    <?php if(
                                                        !empty($passenger['fare_details']['fare_price_type']['price']['taxes']) &&
                                                            is_array($passenger['fare_details']['fare_price_type']['price']['taxes'])): ?>
                                                        <h6 class="mt-3">Tax Breakdown</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $passenger['fare_details']['fare_price_type']['price']['taxes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <li class="list-group-item">
                                                                    <strong><?php echo e(!empty($tax['tax_code']) ? $tax['tax_code'] : 'Unknown Tax'); ?>:</strong>
                                                                    <?php echo e(!empty($tax['amount']) ? $passenger['fare_details']['fare_price_type']['price']['currency'] . ' ' . number_format($tax['amount'], 2) : 'N/A'); ?>

                                                                    (Refundable:
                                                                    <?php echo e(!empty($tax['refund_ind']) ? ($tax['refund_ind'] === 'true' ? 'Yes' : 'No') : 'N/A'); ?>)
                                                                </li>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    <?php else: ?>
                                                        <p>No tax breakdown available.</p>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="card mb-3">
                                        <div class="card-header">
                                            Total Pricing
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><strong>Total Amount:</strong>
                                                    <?php echo e(!empty($xmlBody['totalPrice']) ? 'PKR ' . number_format($xmlBody['totalPrice'], 2) : 'N/A'); ?>

                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No pricing information available.</div>
                    <?php endif; ?>

                    <!-- Baggage Allowances -->
                    <?php if(!empty($xmlBody['baggage_allowances']) && is_array($xmlBody['baggage_allowances'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="baggageInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#baggageInfo" aria-expanded="false" aria-controls="baggageInfo">
                                    Baggage Allowances
                                </button>
                            </h2>
                            <div id="baggageInfo" class="accordion-collapse collapse"
                                aria-labelledby="baggageInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $xmlBody['baggage_allowances']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $baggage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Baggage Allowance
                                                <?php echo e(!empty($baggage['baggage_allowance_id']) ? $baggage['baggage_allowance_id'] : 'Unknown'); ?>

                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Type:</strong>
                                                        <?php echo e(!empty($baggage['type']) ? $baggage['type'] : 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Max Weight:</strong>
                                                        <?php echo e(!empty($baggage['piece_allowance']['max_weight']['value']) ? $baggage['piece_allowance']['max_weight']['value'] . ' ' . $baggage['piece_allowance']['max_weight']['unit'] : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Applicable Party:</strong>
                                                        <?php echo e(!empty($baggage['piece_allowance']['applicable_party']) ? $baggage['piece_allowance']['applicable_party'] : 'N/A'); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">No baggage allowance information available.</div>
                    <?php endif; ?>

                    <!-- Penalties -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="penaltiesHeading">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#penalties" aria-expanded="false" aria-controls="penalties">
                                Penalties & Cancellation Fees
                            </button>
                        </h2>
                        <div id="penalties" class="accordion-collapse collapse" aria-labelledby="penaltiesHeading"
                            data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <?php if(!empty($xmlBody['passengers']) && is_array($xmlBody['passengers'])): ?>
                                    <h6>Per Passenger Cancellation Fees</h6>
                                    <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($passenger['cancel_fee'])): ?>
                                            <div class="card mb-2">
                                                <div class="card-header">
                                                    <strong><?php echo e(!empty($passenger['ptc']) ? strtoupper($passenger['ptc']) : 'Unknown'); ?>

                                                        -
                                                        <?php echo e(!empty($passenger['given_name']) ? $passenger['given_name'] : ''); ?>

                                                        <?php echo e(!empty($passenger['surname']) ? $passenger['surname'] : ''); ?></strong>
                                                </div>
                                                <div class="card-body p-2">
                                                    <ul class="list-group list-group-flush">
                                                        <li class="list-group-item d-flex justify-content-between">
                                                            <span><strong>Penalty ID:</strong>
                                                                <?php echo e(!empty($passenger['cancel_fee']['penalty_id']) ? $passenger['cancel_fee']['penalty_id'] : 'N/A'); ?></span>
                                                        </li>
                                                        <li class="list-group-item d-flex justify-content-between">
                                                            <span><strong>Type:</strong>
                                                                <?php echo e(!empty($passenger['cancel_fee']['type_code']) ? $passenger['cancel_fee']['type_code'] : 'N/A'); ?></span>
                                                        </li>
                                                        <li class="list-group-item d-flex justify-content-between">
                                                            <span><strong>Cancellation Fee:</strong></span>
                                                            <span class="fw-bold text-danger">
                                                                <?php echo e(!empty($passenger['cancel_fee']['cancel_fee']) ? 'PKR ' . number_format($passenger['cancel_fee']['cancel_fee'], 2) : 'PKR 0.00'); ?>

                                                            </span>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <!-- Summary Table -->
                                    <div class="card mt-4">
                                        <div class="card-header">
                                            <strong>Penalty Summary</strong>
                                        </div>
                                        <div class="card-body p-3">
                                            <div class="table-responsive">
                                                <table class="table table-sm table-bordered">
                                                    <thead class="table-dark">
                                                        <tr>
                                                            <th>Passenger Type</th>
                                                            <th>Passenger Name</th>
                                                            <th>Penalty Type</th>
                                                            <th>Amount (PKR)</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(!empty($passenger['cancel_fee'])): ?>
                                                                <tr>
                                                                    <td>
                                                                        <span
                                                                            class="badge bg-<?php echo e($passenger['ptc'] === 'ADT' ? 'primary' : ($passenger['ptc'] === 'CHD' ? 'warning' : 'info')); ?>">
                                                                            <?php echo e(!empty($passenger['ptc']) ? $passenger['ptc'] : 'N/A'); ?>

                                                                        </span>
                                                                    </td>
                                                                    <td><?php echo e(!empty($passenger['given_name']) ? $passenger['given_name'] : ''); ?>

                                                                        <?php echo e(!empty($passenger['surname']) ? $passenger['surname'] : ''); ?>

                                                                    </td>
                                                                    <td><?php echo e(!empty($passenger['cancel_fee']['type_code']) ? $passenger['cancel_fee']['type_code'] : 'N/A'); ?>

                                                                    </td>
                                                                    <td class="fw-bold text-end">
                                                                        <span
                                                                            class="text-danger"><?php echo e(!empty($passenger['cancel_fee']['cancel_fee']) ? number_format($passenger['cancel_fee']['cancel_fee'], 2) : '0.00'); ?></span>
                                                                    </td>
                                                                </tr>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <tr class="table-light fw-bold">
                                                            <td colspan="3" class="text-end">Total Penalties:</td>
                                                            <td class="text-end text-danger">
                                                                PKR
                                                                <?php echo e(array_sum(array_column(array_filter($xmlBody['passengers'], function ($p) {return !empty($p['cancel_fee']['cancel_fee']);}),'cancel_fee','cancel_fee')) | number_format(0)); ?>

                                                            </td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="alert alert-warning">
                                        <i class="fas fa-exclamation-triangle"></i> No passenger data available to
                                        display penalties.
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <div class="alert alert-warning">No booking request data available for PIA.</div>
            <?php endif; ?>
        <?php elseif($airline === 'airblue'): ?>
            <?php if($bookingRequest && is_array($xmlBody) && !empty($xmlBody['data'])): ?>
                <?php
                    $data = $xmlBody['data'] ?? [];
                    $bookingInfo = $data['booking'] ?? [];
                    $flights = $data['flights'] ?? [];
                    $travelers = $data['travelers'] ?? [];
                    $seats = $data['seats'] ?? [];
                    $ancillaries = $data['ancillaries'] ?? [];
                    $priceBreakdown = $data['price_breakdown'] ?? [];
                    $raw = $data['raw'] ?? [];
                ?>
                <div class="accordion" id="bookingAccordion">
                    <!-- General Booking Information -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="generalInfoHeading">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                data-bs-target="#generalInfo" aria-expanded="true" aria-controls="generalInfo">
                                General Booking Information Airblue
                            </button>
                        </h2>
                        <div id="generalInfo" class="accordion-collapse collapse show"
                            aria-labelledby="generalInfoHeading" data-bs-parent="#bookingAccordion">
                            <div class="accordion-body">
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><strong>ID:</strong>
                                        <?php echo e($bookingRequest->id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Airline:</strong>
                                        <?php echo e($bookingRequest->airline ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>PNR:</strong>
                                        <?php echo e($bookingInfo['pnr'] ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Instance:</strong>
                                        <?php echo e($bookingInfo['instance'] ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Ticket Time Limit:</strong>
                                        <?php echo e(!empty($data['ticket_time_limit']) ? \Carbon\Carbon::parse($data['ticket_time_limit'])->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Status:</strong>
                                        <?php echo e(!empty($data['success']) ? ($data['success'] === 'true' ? 'Success' : 'Failed') : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Total Amount:</strong>
                                        <?php echo e(!empty($data['total']['amount']) && !empty($data['total']['currency']) ? $data['total']['currency'] . ' ' . number_format($data['total']['amount'], 2) : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Client ID:</strong>
                                        <?php echo e($bookingRequest->client_id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Booking ID:</strong>
                                        <?php echo e($bookingRequest->booking_id ?? 'N/A'); ?></li>
                                    <li class="list-group-item"><strong>Created At:</strong>
                                        <?php echo e(!empty($bookingRequest->created_at) ? \Carbon\Carbon::parse($bookingRequest->created_at)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                    <li class="list-group-item"><strong>Updated At:</strong>
                                        <?php echo e(!empty($bookingRequest->updated_at) ? \Carbon\Carbon::parse($bookingRequest->updated_at)->format('d M Y, H:i') : 'N/A'); ?>

                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>

                    <!-- User Information -->
                    <?php if(!empty($xmlBody['user']) && is_array($xmlBody['user'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="userInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#userInfo" aria-expanded="false" aria-controls="userInfo">
                                    User Information
                                </button>
                            </h2>
                            <div id="userInfo" class="accordion-collapse collapse" aria-labelledby="userInfoHeading"
                                data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <ul class="list-group list-group-flush">
                                        <li class="list-group-item"><strong>Full Name:</strong>
                                            <?php echo e($xmlBody['user']['userFullName'] ?? 'N/A'); ?></li>
                                        <li class="list-group-item"><strong>Email:</strong>
                                            <?php echo e($xmlBody['user']['userEmail'] ?? 'N/A'); ?></li>
                                        <li class="list-group-item"><strong>Phone:</strong>
                                            <?php echo e(!empty($xmlBody['user']['userPhoneCode']) ? '+' . $xmlBody['user']['userPhoneCode'] . ' ' : ''); ?><?php echo e($xmlBody['user']['userPhone'] ?? 'N/A'); ?>

                                        </li>
                                        <li class="list-group-item"><strong>City:</strong>
                                            <?php echo e($xmlBody['user']['city'] ?? 'N/A'); ?></li>
                                        <li class="list-group-item"><strong>Country:</strong>
                                            <?php echo e($xmlBody['user']['country'] ?? 'N/A'); ?></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Passenger Information -->
                    <?php if(!empty($xmlBody['passengers']) && is_array($xmlBody['passengers'])): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="passengerInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#passengerInfo" aria-expanded="false"
                                    aria-controls="passengerInfo">
                                    Passenger Information
                                </button>
                            </h2>
                            <div id="passengerInfo" class="accordion-collapse collapse"
                                aria-labelledby="passengerInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $xmlBody['passengers']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Passenger <?php echo e($index + 1); ?> (<?php echo e($passenger['type'] ?? 'N/A'); ?>)
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Name:</strong>
                                                        <?php echo e(!empty($passenger['title']) ? $passenger['title'] . ' ' : ''); ?><?php echo e($passenger['name'] ?? ''); ?>

                                                        <?php echo e($passenger['surname'] ?? ''); ?></li>
                                                    <li class="list-group-item"><strong>Date of Birth:</strong>
                                                        <?php echo e(!empty($passenger['dob']) ? \Carbon\Carbon::parse($passenger['dob'])->format('d M Y') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Nationality:</strong>
                                                        <?php echo e($passenger['nationality'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Passport Number:</strong>
                                                        <?php echo e($passenger['passportNumber'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Passport Expiry:</strong>
                                                        <?php echo e(!empty($passenger['passportExpiry']) ? \Carbon\Carbon::parse($passenger['passportExpiry'])->format('d M Y') : 'N/A'); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Travelers Information -->
                    <?php if(!empty($travelers) && is_array($travelers)): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="travelersInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#travelersInfo" aria-expanded="false"
                                    aria-controls="travelersInfo">
                                    Travelers Information
                                </button>
                            </h2>
                            <div id="travelersInfo" class="accordion-collapse collapse"
                                aria-labelledby="travelersInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $travelers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $traveler): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Traveler <?php echo e($traveler['rph'] ?? 'N/A'); ?>

                                                (<?php echo e($traveler['type'] ?? 'N/A'); ?>)
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Full Name:</strong>
                                                        <?php echo e($traveler['full_name'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>First Name:</strong>
                                                        <?php echo e($traveler['first_name'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Last Name:</strong>
                                                        <?php echo e($traveler['last_name'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Title:</strong>
                                                        <?php echo e($traveler['title'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Birth Date:</strong>
                                                        <?php echo e(!empty($traveler['birth_date']) ? \Carbon\Carbon::parse($traveler['birth_date'])->format('d M Y') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Phone:</strong>
                                                        <?php echo e($traveler['phone'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Email:</strong>
                                                        <?php echo e($traveler['email'] ?? 'N/A'); ?></li>
                                                    <?php if(!empty($traveler['document'])): ?>
                                                        <li class="list-group-item"><strong>Document ID:</strong>
                                                            <?php echo e($traveler['document']['id'] ?? 'N/A'); ?></li>
                                                        <li class="list-group-item"><strong>Document Type:</strong>
                                                            <?php echo e($traveler['document']['type'] ?? 'N/A'); ?></li>
                                                        <li class="list-group-item"><strong>Issue Country:</strong>
                                                            <?php echo e($traveler['document']['issue_country'] ?? 'N/A'); ?></li>
                                                        <li class="list-group-item"><strong>Nationality:</strong>
                                                            <?php echo e($traveler['document']['nationality'] ?? 'N/A'); ?></li>
                                                        <li class="list-group-item"><strong>Expire Date:</strong>
                                                            <?php echo e(!empty($traveler['document']['expire_date']) ? \Carbon\Carbon::parse($traveler['document']['expire_date'])->format('d M Y') : 'N/A'); ?>

                                                        </li>
                                                    <?php endif; ?>
                                                    <?php if(!empty($traveler['segments'])): ?>
                                                        <li class="list-group-item">
                                                            <strong>Flight Segments:</strong>
                                                            <?php echo e(is_array($traveler['segments'])
                                                                ? implode(', ', $traveler['segments'])
                                                                : $traveler['segments']); ?>

                                                        </li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Flight Segments -->
                    <?php if(!empty($flights) && is_array($flights)): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="segmentsHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#segments" aria-expanded="false" aria-controls="segments">
                                    Flight Segments
                                </button>
                            </h2>
                            <div id="segments" class="accordion-collapse collapse" aria-labelledby="segmentsHeading"
                                data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Segment <?php echo e($flight['rph'] ?? 'N/A'); ?>:
                                                <?php echo e($flight['departure_airport'] ?? 'N/A'); ?> to
                                                <?php echo e($flight['arrival_airport'] ?? 'N/A'); ?>

                                            </div>
                                            <div class="card-body">
                                                <h6>Flight Details</h6>
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Flight Number:</strong>
                                                        <?php echo e($flight['flight_number'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Departure:</strong>
                                                        <?php echo e($flight['departure_airport'] ?? 'N/A'); ?><?php echo e(!empty($flight['departure_terminal']) ? ' (Terminal ' . $flight['departure_terminal'] . ')' : ''); ?>

                                                        on
                                                        <?php echo e(!empty($flight['departure_datetime']) ? \Carbon\Carbon::parse($flight['departure_datetime'])->format('d M Y, H:i') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Arrival:</strong>
                                                        <?php echo e($flight['arrival_airport'] ?? 'N/A'); ?><?php echo e(!empty($flight['arrival_terminal']) ? ' (Terminal ' . $flight['arrival_terminal'] . ')' : ''); ?>

                                                        on
                                                        <?php echo e(!empty($flight['arrival_datetime']) ? \Carbon\Carbon::parse($flight['arrival_datetime'])->format('d M Y, H:i') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Duration:</strong>
                                                        <?php echo e(!empty($flight['departure_datetime']) && !empty($flight['arrival_datetime']) ? \Carbon\Carbon::parse($flight['departure_datetime'])->diffInMinutes(\Carbon\Carbon::parse($flight['arrival_datetime'])) . ' minutes' : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Operating Airline:</strong>
                                                        <?php echo e($flight['operating_airline'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Marketing Airline:</strong>
                                                        <?php echo e($flight['marketing_airline'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Aircraft:</strong>
                                                        <?php echo e($flight['equipment'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Cabin Class:</strong>
                                                        <?php echo e($flight['cabin'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Fare Type:</strong>
                                                        <?php echo e($flight['fare_type'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Status:</strong>
                                                        <?php echo e($flight['status'] ?? 'N/A'); ?></li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Seats Information -->
                    <?php if(!empty($seats) && is_array($seats)): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="seatsInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#seatsInfo" aria-expanded="false" aria-controls="seatsInfo">
                                    Seat Selections
                                </button>
                            </h2>
                            <div id="seatsInfo" class="accordion-collapse collapse"
                                aria-labelledby="seatsInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $seats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $seat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Seat:
                                                <?php echo e($seat['row_number'] ?? 'N/A'); ?><?php echo e($seat['seat_number'] ?? 'N/A'); ?>

                                                (Flight RPH: <?php echo e($seat['flight_rph'] ?? 'N/A'); ?>)
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>Traveler RPH:</strong>
                                                        <?php echo e($seat['traveler_rph'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Seat:</strong> Row
                                                        <?php echo e($seat['row_number'] ?? 'N/A'); ?>, Seat
                                                        <?php echo e($seat['seat_number'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Status:</strong>
                                                        <?php echo e($seat['status'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Price:</strong>
                                                        <?php echo e(!empty($seat['price']) && !empty($seat['currency']) ? $seat['currency'] . ' ' . number_format($seat['price'], 2) : 'Free'); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Ancillaries (Add-ons) -->
                    <?php if(!empty($ancillaries) && is_array($ancillaries)): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="ancillariesInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#ancillariesInfo" aria-expanded="false"
                                    aria-controls="ancillariesInfo">
                                    Ancillaries (Add-ons)
                                </button>
                            </h2>
                            <div id="ancillariesInfo" class="accordion-collapse collapse"
                                aria-labelledby="ancillariesInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $ancillaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ancillary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                <?php echo e($ancillary['title'] ?? 'N/A'); ?> (Flight RPH:
                                                <?php echo e($ancillary['flight_rph'] ?? 'N/A'); ?>)
                                            </div>
                                            <div class="card-body">
                                                <ul class="list-group list-group-flush">
                                                    <li class="list-group-item"><strong>SSR Code:</strong>
                                                        <?php echo e($ancillary['ssr_code'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Item Code:</strong>
                                                        <?php echo e($ancillary['item_code'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Title:</strong>
                                                        <?php echo e($ancillary['title'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Description:</strong>
                                                        <?php echo e($ancillary['description'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Traveler RPH:</strong>
                                                        <?php echo e($ancillary['traveler_rph'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Price:</strong>
                                                        <?php echo e(!empty($ancillary['price']) && !empty($ancillary['currency']) ? $ancillary['currency'] . ' ' . number_format($ancillary['price'], 2) : 'Free'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Status:</strong>
                                                        <?php echo e($ancillary['status'] ?? 'N/A'); ?></li>
                                                    <li class="list-group-item"><strong>Refundable:</strong>
                                                        <?php echo e(!empty($ancillary['refundable']) ? ($ancillary['refundable'] === 'true' ? 'Yes' : 'No') : 'N/A'); ?>

                                                    </li>
                                                    <li class="list-group-item"><strong>Expires:</strong>
                                                        <?php echo e(!empty($ancillary['expires']) ? \Carbon\Carbon::parse($ancillary['expires'])->format('d M Y, H:i') : 'N/A'); ?>

                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Pricing Information -->
                    <?php if(!empty($priceBreakdown) && is_array($priceBreakdown)): ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="pricingInfoHeading">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#pricingInfo" aria-expanded="false" aria-controls="pricingInfo">
                                    Pricing Information
                                </button>
                            </h2>
                            <div id="pricingInfo" class="accordion-collapse collapse"
                                aria-labelledby="pricingInfoHeading" data-bs-parent="#bookingAccordion">
                                <div class="accordion-body">
                                    <?php $__currentLoopData = $priceBreakdown; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $breakdown): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="card mb-3">
                                            <div class="card-header">
                                                Passenger Type: <?php echo e($breakdown['passenger_type'] ?? 'N/A'); ?> (Quantity:
                                                <?php echo e($breakdown['quantity'] ?? 'N/A'); ?>)
                                            </div>
                                            <div class="card-body">
                                                <?php if(!empty($breakdown['per_segment_fares']) && is_array($breakdown['per_segment_fares'])): ?>
                                                    <?php $__currentLoopData = $breakdown['per_segment_fares']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segmentFare): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="card mb-3">
                                                            <div class="card-header">
                                                                Route: <?php echo e($segmentFare['from'] ?? 'N/A'); ?> to
                                                                <?php echo e($segmentFare['to'] ?? 'N/A'); ?>

                                                            </div>
                                                            <div class="card-body">
                                                                <ul class="list-group list-group-flush">
                                                                    <li class="list-group-item"><strong>Fare
                                                                            Basis:</strong>
                                                                        <?php echo e($segmentFare['fare_basis'] ?? 'N/A'); ?></li>
                                                                    <li class="list-group-item"><strong>Base
                                                                            Fare:</strong> PKR
                                                                        <?php echo e(!empty($segmentFare['base_fare']) ? number_format($segmentFare['base_fare'], 2) : '0.00'); ?>

                                                                    </li>
                                                                    <li class="list-group-item"><strong>Taxes
                                                                            Total:</strong> PKR
                                                                        <?php echo e(!empty($segmentFare['taxes_total']) ? number_format($segmentFare['taxes_total'], 2) : '0.00'); ?>

                                                                    </li>
                                                                    <li class="list-group-item"><strong>Fees
                                                                            Total:</strong> PKR
                                                                        <?php echo e(!empty($segmentFare['fees_total']) ? number_format($segmentFare['fees_total'], 2) : '0.00'); ?>

                                                                    </li>
                                                                    <li class="list-group-item">
                                                                        <strong>Baggage:</strong>
                                                                        <?php echo e(!empty($segmentFare['baggage']['quantity']) ? $segmentFare['baggage']['quantity'] . ' ' . ($segmentFare['baggage']['unit'] ?? 'KGS') : 'N/A'); ?>

                                                                    </li>
                                                                </ul>
                                                                <?php if(!empty($segmentFare['taxes']) && is_array($segmentFare['taxes'])): ?>
                                                                    <h6 class="mt-3">Tax Breakdown</h6>
                                                                    <ul class="list-group list-group-flush">
                                                                        <?php $__currentLoopData = $segmentFare['taxes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="list-group-item">
                                                                                <strong><?php echo e($tax['TaxCode'] ?? 'Tax'); ?>:</strong>
                                                                                <?php echo e(!empty($tax['CurrencyCode']) && !empty($tax['Amount']) ? $tax['CurrencyCode'] . ' ' . number_format($tax['Amount'], 2) : 'N/A'); ?>

                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                                <?php if(!empty($segmentFare['fees']) && is_array($segmentFare['fees'])): ?>
                                                                    <h6 class="mt-3">Fees Breakdown</h6>
                                                                    <ul class="list-group list-group-flush">
                                                                        <?php $__currentLoopData = $segmentFare['fees']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="list-group-item">
                                                                                <strong><?php echo e($fee['FeeCode'] ?? 'Fee'); ?>:</strong>
                                                                                <?php echo e(!empty($fee['CurrencyCode']) && !empty($fee['Amount']) ? $fee['CurrencyCode'] . ' ' . number_format($fee['Amount'], 2) : 'N/A'); ?>

                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <div class="card mt-3">
                                        <div class="card-header">
                                            <strong>Total Amount</strong>
                                        </div>
                                        <div class="card-body">
                                            <ul class="list-group list-group-flush">
                                                <li class="list-group-item"><strong>Total:</strong>
                                                    <?php echo e(!empty($data['total']['amount']) && !empty($data['total']['currency']) ? $data['total']['currency'] . ' ' . number_format($data['total']['amount'], 2) : 'N/A'); ?>

                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>

                    <!-- Penalties -->
                    <?php if(
                        !empty($raw['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown']) &&
                            is_array($raw['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'])): ?>
                        <?php
                            $fareBreakdowns =
                                is_array($raw['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown']) &&
                                isset($raw['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown'][0])
                                    ? $raw['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown']
                                    : [$raw['PriceInfo']['PTC_FareBreakdowns']['PTC_FareBreakdown']];
                            $hasPenalties = false;
                            foreach ($fareBreakdowns as $fare) {
                                if (!empty($fare['FareInfo']) && is_array($fare['FareInfo'])) {
                                    $fareInfos =
                                        is_array($fare['FareInfo']) && isset($fare['FareInfo'][0])
                                            ? $fare['FareInfo']
                                            : [$fare['FareInfo']];
                                    foreach ($fareInfos as $fareInfo) {
                                        if (!empty($fareInfo['RuleInfo']['ChargesRules'])) {
                                            $hasPenalties = true;
                                            break 2;
                                        }
                                    }
                                }
                            }
                        ?>
                        <?php if($hasPenalties): ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="penaltiesHeading">
                                    <button class="accordion-button collapsed" type="button"
                                        data-bs-toggle="collapse" data-bs-target="#penalties" aria-expanded="false"
                                        aria-controls="penalties">
                                        Penalties & Cancellation Fees
                                    </button>
                                </h2>
                                <div id="penalties" class="accordion-collapse collapse"
                                    aria-labelledby="penaltiesHeading" data-bs-parent="#bookingAccordion">
                                    <div class="accordion-body">
                                        <?php $__currentLoopData = $fareBreakdowns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fare): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(!empty($fare['FareInfo']) && is_array($fare['FareInfo'])): ?>
                                                <?php
                                                    $fareInfos =
                                                        is_array($fare['FareInfo']) && isset($fare['FareInfo'][0])
                                                            ? $fare['FareInfo']
                                                            : [$fare['FareInfo']];
                                                ?>
                                                <?php $__currentLoopData = $fareInfos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fareInfo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!empty($fareInfo['RuleInfo']['ChargesRules'])): ?>
                                                        <div class="card mb-3">
                                                            <div class="card-header">
                                                                Route:
                                                                <?php echo e(!empty($fareInfo['DepartureAirport']['@attributes']['LocationCode']) ? $fareInfo['DepartureAirport']['@attributes']['LocationCode'] : 'N/A'); ?>

                                                                to
                                                                <?php echo e(!empty($fareInfo['ArrivalAirport']['@attributes']['LocationCode']) ? $fareInfo['ArrivalAirport']['@attributes']['LocationCode'] : 'N/A'); ?>

                                                            </div>
                                                            <div class="card-body">
                                                                <?php if(!empty($fareInfo['RuleInfo']['ChargesRules']['VoluntaryChanges']['Penalty'])): ?>
                                                                    <h6>Change Fees</h6>
                                                                    <ul class="list-group list-group-flush">
                                                                        <?php
                                                                            $changePenalties =
                                                                                is_array(
                                                                                    $fareInfo['RuleInfo'][
                                                                                        'ChargesRules'
                                                                                    ]['VoluntaryChanges']['Penalty'],
                                                                                ) &&
                                                                                isset(
                                                                                    $fareInfo['RuleInfo'][
                                                                                        'ChargesRules'
                                                                                    ]['VoluntaryChanges']['Penalty'][0],
                                                                                )
                                                                                    ? $fareInfo['RuleInfo'][
                                                                                        'ChargesRules'
                                                                                    ]['VoluntaryChanges']['Penalty']
                                                                                    : [
                                                                                        $fareInfo['RuleInfo'][
                                                                                            'ChargesRules'
                                                                                        ]['VoluntaryChanges'][
                                                                                            'Penalty'
                                                                                        ],
                                                                                    ];
                                                                        ?>
                                                                        <?php $__currentLoopData = $changePenalties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penalty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="list-group-item">
                                                                                <strong><?php echo e(!empty($penalty['@attributes']['HoursBeforeDeparture']) ? $penalty['@attributes']['HoursBeforeDeparture'] : 'N/A'); ?>:</strong>
                                                                                <?php echo e(!empty($penalty['@attributes']['CurrencyCode']) && !empty($penalty['@attributes']['Amount']) ? $penalty['@attributes']['CurrencyCode'] . ' ' . number_format($penalty['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                                <?php if(!empty($fareInfo['RuleInfo']['ChargesRules']['VoluntaryRefunds']['Penalty'])): ?>
                                                                    <h6 class="mt-3">Cancellation / Refund Fees</h6>
                                                                    <ul class="list-group list-group-flush">
                                                                        <?php
                                                                            $refundPenalties =
                                                                                is_array(
                                                                                    $fareInfo['RuleInfo'][
                                                                                        'ChargesRules'
                                                                                    ]['VoluntaryRefunds']['Penalty'],
                                                                                ) &&
                                                                                isset(
                                                                                    $fareInfo['RuleInfo'][
                                                                                        'ChargesRules'
                                                                                    ]['VoluntaryRefunds']['Penalty'][0],
                                                                                )
                                                                                    ? $fareInfo['RuleInfo'][
                                                                                        'ChargesRules'
                                                                                    ]['VoluntaryRefunds']['Penalty']
                                                                                    : [
                                                                                        $fareInfo['RuleInfo'][
                                                                                            'ChargesRules'
                                                                                        ]['VoluntaryRefunds'][
                                                                                            'Penalty'
                                                                                        ],
                                                                                    ];
                                                                        ?>
                                                                        <?php $__currentLoopData = $refundPenalties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penalty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <li class="list-group-item">
                                                                                <strong><?php echo e(!empty($penalty['@attributes']['HoursBeforeDeparture']) ? $penalty['@attributes']['HoursBeforeDeparture'] : 'N/A'); ?>:</strong>
                                                                                <?php echo e(!empty($penalty['@attributes']['CurrencyCode']) && !empty($penalty['@attributes']['Amount']) ? $penalty['@attributes']['CurrencyCode'] . ' ' . number_format($penalty['@attributes']['Amount'], 2) : 'N/A'); ?>

                                                                            </li>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </ul>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            <?php else: ?>
                <div class="alert alert-warning">No booking request data available for Airblue.</div>
            <?php endif; ?>
        <?php endif; ?>
    <?php else: ?>
        <div class="alert alert-danger">No booking request data available.</div>
    <?php endif; ?>
</div>
<?php /**PATH D:\wamp64\www\travelandtours\resources\views/components/admin/show-xml-data.blade.php ENDPATH**/ ?>