<?php
    $layout = request()->routeIs('admin.login') ? 'home/layouts/layout' : 'home/layouts/master';
?>

<?php $__env->startSection('title', 'Login'); ?>
<?php $__env->startSection('style'); ?>
  <link rel="stylesheet" href="<?php echo e(url('assets/css/login.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <?php $isAdmin = request()->routeIs('admin.login') ? true : false; ?>
    <section class="search-bookings">
        <div class="container d-flex justify-content-center">
            <div class="booking-box">
                <h2>Login to your account <?php if($isAdmin): ?> (Admin) <?php endif; ?></h2>
                <div class="form-group">
                    <label>Email Address</label>
                    <input type="email" id="email" name="email" placeholder="e.g. name@gmail.com" required>
                    <div class="form-note">Enter your valid email address.</div>
                </div>
                <div class="form-group">
                    <label>Password</label>
                    <input type="password" id="password" name="password" placeholder="Enter your password" required>
                </div>

                <button class="loginBtn" disabled>Login</button>
                <?php if(!$isAdmin): ?>
                    <p class="registerText mt-2">Don't have an account? <a href="<?php echo e(route('register')); ?>">Register</a></p>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <script>
        $(document).ready(function () {
            const isAdmin = <?php echo json_encode($isAdmin, 15, 512) ?>;

            function validateForm() {
                let email = $('#email').val().trim();
                let password = $('#password').val().trim();
                let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/; // basic email check

                if (emailRegex.test(email) && password.length > 0) {
                    $('.loginBtn').addClass('active').prop('disabled', false);
                } else {
                    $('.loginBtn').removeClass('active').prop('disabled', true);
                }
            }

            // Run validation whenever user types
            $('#email, #password').on('input', validateForm);

            $('.loginBtn').on('click', function (e) {
                e.preventDefault();
                let url = isAdmin ? "<?php echo e(route('admin.login.submit')); ?>" : "<?php echo e(route('login.submit')); ?>";
                let email = $('#email').val().trim();
                let password = $('#password').val().trim();

                if (!email || !password) {
                    _alert('Both fields are required.', 'error');
                    return;
                }

                $.ajax({
                    url,
                    method: 'POST',
                    data: {
                        email: email,
                        password: password,
                        _token: $('meta[name="csrf-token"]').attr('content')
                    },
                    success: res => {
                        let currentUrl = window.location.href;
                        if (currentUrl.includes('/admin') || currentUrl.includes('/agent')) {
                            window.location.href = res.redirect
                        } else {
                            let goBack = localStorage.getItem('flights') || null;
                            window.location.href = (goBack ? `/flights${goBack}` : res.redirect);
                        }
                    },
                    error: function (xhr) {
                        let msg = xhr.responseJSON?.message || 'Login failed.';
                        _alert(msg, 'error');
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make($layout, array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\wamp64\www\destination-travel\resources\views/login.blade.php ENDPATH**/ ?>