<?php $__env->startSection('title', 'Admin Dashboard'); ?>

<?php $__env->startSection('style'); ?>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<style>
   .card-metric {
      border-left: 4px solid #0d6efd;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
   }
   .chart-container {
      position: relative;
      height: 300px;
   }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-fluid py-4">

   <div class="d-flex justify-content-between align-items-center mb-3">
      <h2 class="fw-bold">Welcome, <?php echo e(auth()->user()->name); ?></h2>

      <form method="GET" action="<?php echo e(route('admin.dashboard')); ?>" class="d-flex align-items-center">
         <input type="text" id="daterange" class="form-control me-2 my-0" name="daterange" value="<?php echo e($fromDate->format('Y-m-d')); ?> - <?php echo e($toDate->format('Y-m-d')); ?>" autocomplete="off">
         <input type="hidden" name="from_date" id="from_date" value="<?php echo e($fromDate->format('Y-m-d')); ?>">
         <input type="hidden" name="to_date" id="to_date" value="<?php echo e($toDate->format('Y-m-d')); ?>">
         <?php if(request()->has('from_date') || request()->has('to_date')): ?>
            <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-sm btn_primary">Reset</a>
         <?php endif; ?>
      </form>
   </div>

   <div class="row text-center">
      <div class="col-md-2 mb-3">
         <div class="card card-metric border-primary">
            <div class="card-body">
               <h6>Total Orders</h6>
               <h4><?php echo e($totalOrdersWOError); ?></h4>
            </div>
         </div>
      </div>
      <div class="col-md-2 mb-3">
         <div class="card card-metric border-warning">
            <div class="card-body">
               <h6>Initial Orders</h6>
               <h4><?php echo e($initialOrders); ?></h4>
            </div>
         </div>
      </div>
      <div class="col-md-2 mb-3">
         <div class="card card-metric border-success">
            <div class="card-body">
               <h6>Issued Orders</h6>
               <h4><?php echo e($issuedOrders); ?></h4>
            </div>
         </div>
      </div>
      <div class="col-md-2 mb-3">
         <div class="card card-metric border-danger">
            <div class="card-body">
               <h6>Cancel Orders</h6>
               <h4><?php echo e($cancelOrders); ?></h4>
            </div>
         </div>
      </div>
      <div class="col-md-4 mb-3">
         <div class="card card-metric border-primary">
            <div class="card-body">
               <h6>Total Revenue</h6>
               <h4>PKR <?php echo e(number_format($totalRevenue, 2)); ?></h4>
            </div>
         </div>
      </div>
      
   </div>

   
   <?php if($canViewAll): ?>
   <div class="row mt-4">
      <div class="col-md-4 mb-4">
         <div class="card">
            <div class="card-header">Orders by Status</div>
            <div class="card-body">
               <div class="chart-container">
                  <canvas id="ordersStatusChart"></canvas>
               </div>
            </div>
         </div>
      </div>

      <div class="col-md-4 mb-4">
         <div class="card">
            <div class="card-header">Bookings by Airline</div>
            <div class="card-body">
               <div class="chart-container">
                  <canvas id="bookingsAirlineChart"></canvas>
               </div>
            </div>
         </div>
      </div>

      <div class="col-md-4 mb-4">
         <div class="card">
            <div class="card-header">Revenue Trend</div>
            <div class="card-body">
               <div class="chart-container">
                  <canvas id="revenueChart"></canvas>
               </div>
            </div>
         </div>
      </div>
   </div>
   <?php endif; ?>

   <div class="row mt-4">
      <div class="col-md-12">
         <div class="card">
            <div class="card-header">Recent Orders</div>
            <div class="card-body table-responsive">
               <table class="table table-striped">
                  <thead>
                     <tr>
                        <th>Serial No.</th>
                        <th>Order ID</th>
                        <th>Reference</th>
                        <th>Airline</th>
                        <th>Status</th>
                        <th>Type</th>
                        <th>Total</th>
                        <th>Created At</th>
                     </tr>
                  </thead>
                  <tbody>
                     <?php $__currentLoopData = $recentOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                     <tr>
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($order->id); ?></td>
                        <td><?php echo e($order->flight_booking_id ?? $order->order_id ?? ''); ?></td>
                        <td><?php echo e($order->airline); ?></td>
                        <td><span class="badge bg-<?php echo e($order->status == 'issued' ? 'success' : ($order->status == 'error' ? 'danger' : 'secondary')); ?>"><?php echo e(strtoupper($order->status)); ?></span></td>
                        <td><?php echo e($order->type ?? '-'); ?></td>
                        <td><?php echo e($order->total_price ?? 0); ?></td>
                        <td><?php echo e($order->created_at->format('d M Y h:i a')); ?></td>
                     </tr>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
               </table>
            </div>
         </div>
      </div>
   </div>

</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<script>
   $(function() {
      const start = moment("<?php echo e($fromDate->format('Y-m-d')); ?>");
      const end   = moment("<?php echo e($toDate->format('Y-m-d')); ?>");

      function updateDisplay(start, end) {
         $('#daterange').val(start.format('YYYY-MM-DD') + ' - ' + end.format('YYYY-MM-DD'));
         $('#from_date').val(start.format('YYYY-MM-DD'));
         $('#to_date').val(end.format('YYYY-MM-DD'));
      }

      $('#daterange').daterangepicker({
         startDate: start,
         endDate: end,
         ranges: {
            'Today': [moment(), moment()],
            'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Last 7 Days': [moment().subtract(6, 'days'), moment()],
            'Last 30 Days': [moment().subtract(29, 'days'), moment()],
            'This Month': [moment().startOf('month'), moment().endOf('month')],
            'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
         },
         locale: {
            format: 'YYYY-MM-DD'
         }
      }, updateDisplay);

      updateDisplay(start, end);
   });
   $('#daterange').on('apply.daterangepicker', function(ev, picker) {
      $(this).closest('form').submit();
   });

   <?php if($canViewAll): ?>
      new Chart(document.getElementById('ordersStatusChart'), {
         type: 'doughnut',
         data: {
            labels: <?php echo json_encode($statusData->keys()); ?>,
            datasets: [{
               data: <?php echo json_encode($statusData->values()); ?>,
               backgroundColor: ['#0d6efd','#198754','#dc3545','#ffc107']
            }]
         }
      });

      new Chart(document.getElementById('bookingsAirlineChart'), {
         type: 'bar',
         data: {
            labels: <?php echo json_encode($bookingsByAirline->pluck('airline')); ?>,
            datasets: [{
               label: 'Total Bookings by Airline',
               data: <?php echo json_encode($bookingsByAirline->pluck('total')); ?>,
               backgroundColor: '#0d6efd'
            }]
         },
         options: { responsive: true, plugins: { legend: { display: false } } }
      });

      // Revenue Trend chart
      new Chart(document.getElementById('revenueChart'), {
         type: 'line',
         data: {
            labels: <?php echo json_encode($revenueTrend->pluck('date')); ?>,
            datasets: [{
               label: 'Revenue (PKR)',
               data: <?php echo json_encode($revenueTrend->pluck('total')); ?>,
               fill: true,
               borderColor: '#0d6efd',
               tension: 0.3
            }]
         }
      });
   <?php endif; ?>
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin/layouts/master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\wamp64\www\destination-travel\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>