<?php $__env->startSection('title', 'Order Manage'); ?>
<?php $__env->startSection('style'); ?>
  <style>
    .box {
      border: 1px solid #dee2e6;
      padding: 15px;
      border-radius: 4px;
      margin-bottom: 1rem;
      overflow-x: auto; 
    }
    .section-title {
      font-weight: 600;
      font-size: 1rem;
      margin-bottom: 0.5rem;
    }
    .accordion-button {
        font-weight: bold;
    }
    .list-group-item {
        border-left: 0;
        border-right: 0;
    }
    .card-header {
        background-color: #f8f9fa;
        font-weight: 500;
    }
    .alert {
        margin-bottom: 1rem;
    }
  </style>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    $airline = $booking->airline ? strtolower($booking->airline) : 'N/A';
?>
<div class="row">
    <!-- Left Side -->
    <div class="col-md-3 left-side">
        
        <div class="card box">
            <div class="section-title">Ticket And Receipt Email</div>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="paymentReceipt">
                <label class="form-check-label" for="paymentReceipt">Payment Receipt</label>
            </div>
            <div class="form-check">
                <input class="form-check-input" type="checkbox" id="eTicket">
                <label class="form-check-label" for="eTicket">E-ticket</label>
            </div>
            <button class="btn btn-sm btn_secondary">Send Email</button>
        </div>

        
        <form method="POST" action="<?php echo e(route('update.client', $booking->client->id)); ?>" class="card box">
            <?php echo csrf_field(); ?>
            <div class="section-title">Contact Details (User)</div>
            <div class="mb-2">
                <input type="text" name="name" class="form-control mb-1" placeholder="name" value="<?php echo e($booking->client->name); ?>">
                <input type="email" name="email" class="form-control mb-1" placeholder="email" value="<?php echo e($booking->client->email); ?>">
                <div class="input-group mb-3">
                    <span class="input-group-text">+<?php echo e($booking->client->phone_code); ?></span>
                    <input type="number" placeholder="phone" name="phone" class="form-control m-0" value="<?php echo e($booking->client->phone); ?>">
                </div>
                <button class="btn btn-sm btn_primary" type="submit">Update</button>
            </div>
        </form>

        
        <div class="card box">
            <label class="form-label">Select Agent</label>
            <select class="form-select mb-2" id="agentSelect" <?php if(!empty($booking->agent_id)): ?> disabled <?php endif; ?>>
                <option selected disabled value="">-- Select Agent --</option>
                <?php $__empty_1 = true; $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <option value="<?php echo e($agent->id); ?>" <?php if(isset($booking->agent_id) && $booking->agent_id == $agent->id): echo 'selected'; endif; ?>><?php echo e($agent->email); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <option selected>-- No Agents Found --</option>
                <?php endif; ?>
            </select>
        </div>
        
        <div class="box notes-box">
            <div class="section-title d-flex justify-content-between">
                <span>Notes</span>
                <label for="noteImage" class="btn btn-sm btn_secondary">Add Image</label>
                <input type="file" class="d-none" name="noteImage" id="noteImage">
            </div>
            <textarea id="note-editor" class="form-control"></textarea> 
            <div class="d-flex justify-content-between mt-2">
                <button type="button" id="addNoteBtn" class="btn btn-sm btn_secondary">Add Notes</button>
                <button type="button" class="btn btn-sm btn_secondary_outline" id="showLogHistoryBtn">History</button>
            </div>
        </div>
        <!-- Notes Modal -->
        <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'logHistoryModal','title' => 'Notes History','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
            <div class="modal-body" id="logHistoryContent">
                <div class="text-center py-4">Loading...</div>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>

        <div class="box notes-box">
            <div class="section-title">Add Discount</div>
            <input type="text" class="form-control mb-1" placeholder="Voucher Promocode">
            <button class="btn btn-sm btn_secondary mt-2">Add Discount</button>
        </div>

        
        <div class="card box">
            <div class="section-title">Order Cancelation</div>
            <div class="d-flex justify-content-start gap-3 mt-2">
                <?php if($booking->canceled_at): ?>
                    <div class="py-2"><strong>Order Canceled At:</strong> <?php echo e(\Carbon\Carbon::parse($booking->canceled_at)->format('d M Y h:i A')); ?></div>
                <?php else: ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('cancel booking')): ?>
                        <button class="btn btn-sm btn_secondary" data-bs-toggle="modal" data-bs-target="#cacelOrderDetailsModal">Cancel Order</button>
                    <?php endif; ?>
                <?php endif; ?>
                
            </div>
            <!-- Approve Flight Modal -->
            <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'cacelOrderDetailsModal','title' => 'Cancel / Change / Refund Fees','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                <div class="modal-body">
                    <?php if($airline === 'flyjinnah' && $booking->status !== 'issued'): ?>
                        <p>Cancellation policies are not available for FlyJinnah bookings at this time.</p>
                    <?php else: ?>
                        <div class="card mb-3 shadow-sm">
                            <div class="card-body p-0">
                                <?php if($airline === 'emirates'): ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $booking->bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <span class="fw-semibold">Passenger(s): <?php echo e($item->passenger_code); ?></span>
                                        </div>
                                        <?php $__empty_2 = true; $__currentLoopData = $item->penalties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penalty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                            <?php
                                                $cancel = is_array($penalty->cancel_fee) ? $penalty->cancel_fee : json_decode($penalty->cancel_fee, true);
                                                $change = is_array($penalty->change_fee) ? $penalty->change_fee : json_decode($penalty->change_fee, true);
                                                $refund = is_array($penalty->refund_fee) ? $penalty->refund_fee : json_decode($penalty->refund_fee, true);
                                            ?>
                                            <div class="p-3 border-bottom">
                                                <h6 class="mb-3 text-muted"><?php echo e($penalty->destination); ?> → <?php echo e($penalty->arrival); ?></h6>
                                                <?php
                                                    $sections = [
                                                        'Cancel Fees' => $cancel,
                                                        'Change Fees' => $change,
                                                        'Refund Policy / Fees' => $refund
                                                    ];
                                                ?>
                                                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $title => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!empty($data)): ?>
                                                        <h6 class="mb-2"><?php echo e($title); ?></h6>
                                                        <?php if($title === 'Refund Policy / Fees' && isset($data['Status'])): ?>
                                                            <p class="mb-0"><strong>Status:</strong> <?php echo e($data['Status']); ?></p>
                                                        <?php else: ?>
                                                            <table class="table table-sm align-middle mb-3">
                                                                <thead>
                                                                    <tr>
                                                                        <th style="width: 40%">When</th>
                                                                        <th style="width: 30%">Amount</th>
                                                                        <th style="width: 30%">Application</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $when => $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <tr>
                                                                            <td><?php echo e($when); ?></td>
                                                                            <td><?php echo e(isset($fee['price']) ? ($fee['price']['amount'] ?? '') . ' ' . ($fee['price']['code'] ?? '') : ''); ?></td>
                                                                            <td><?php echo e($fee['amountApplication'] ?? ''); ?></td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </tbody>
                                                            </table>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(empty($cancel) && empty($change) && empty($refund)): ?>
                                                    <p class="text-muted mb-0">No penalty info available.</p>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                            <div class="p-3">
                                                <p class="text-muted mb-0">No penalties found for this booking item.</p>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <p class="text-muted mb-0">No booking items found.</p>
                                    <?php endif; ?>
                                <?php elseif($airline === 'flyjinnah'): ?>
                                    <?php
                                        $xmlBody = $booking->bookingRequest && isset($booking->bookingRequest->xml_body) ? json_decode($booking->bookingRequest->xml_body, true) : null;
                                        $airReservation = $xmlBody['response']['Body']['OTA_AirBookRS']['AirReservation'] ?? $xmlBody['Body']['OTA_AirBookRS']['AirReservation'] ?? null;
                                        $options = $airReservation['AirItinerary']['OriginDestinationOptions']['OriginDestinationOption'] ?? [];
                                        $options = is_array($options) && isset($options[0]) ? $options : [$options];
                                        $hasPenalties = false;
                                    ?>
                                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($option['FlightSegment']) && is_array($option['FlightSegment'])): ?>
                                            <?php $__currentLoopData = $option['FlightSegment']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($segment['AvailableFlexiOperations']['FlexiOperations']) && is_array($segment['AvailableFlexiOperations']['FlexiOperations'])): ?>
                                                    <?php $hasPenalties = true; ?>
                                                    <div class="p-3 border-bottom">
                                                        <h6 class="mb-3 text-muted">
                                                            <?php echo e($segment['DepartureAirport']['@attributes']['LocationCode'] ?? 'N/A'); ?> → <?php echo e($segment['ArrivalAirport']['@attributes']['LocationCode'] ?? 'N/A'); ?>

                                                        </h6>
                                                        <h6>Flexi Operations</h6>
                                                        <ul class="list-group list-group-flush">
                                                            <?php $__currentLoopData = $segment['AvailableFlexiOperations']['FlexiOperations']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if(is_array($operation) && !empty($operation['@attributes'])): ?>
                                                                    <li class="list-group-item">
                                                                        <strong><?php echo e($operation['@attributes']['AllowedOperationName'] ?? 'N/A'); ?>:</strong>
                                                                        Allowed <?php echo e($operation['@attributes']['NumberOfAllowedOperations'] ?? 'N/A'); ?> time(s),
                                                                        Cutoff: <?php echo e($operation['@attributes']['FlexiOperationCutoverTimeInMinutes'] ?? 'N/A'); ?> minutes
                                                                    </li>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php if(!$hasPenalties): ?>
                                        <div class="p-3">
                                            <p class="text-muted mb-0">No penalty information available.</p>
                                        </div>
                                    <?php endif; ?>
                                <?php elseif($airline === 'pia'): ?>
                                    <?php $__empty_1 = true; $__currentLoopData = $booking->bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <div class="card-header d-flex justify-content-between align-items-center">
                                            <span class="fw-semibold">Passenger(s): <?php echo e($item->passenger_code); ?></span>
                                        </div>
                                        <?php $__empty_2 = true; $__currentLoopData = $item->penalties; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $penalty): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                            <?php
                                                $cancel = is_array($penalty->cancel_fee) ? $penalty->cancel_fee : json_decode($penalty->cancel_fee, true);
                                                $change = is_array($penalty->change_fee) ? $penalty->change_fee : json_decode($penalty->change_fee, true);
                                                $refund = is_array($penalty->refund_fee) ? $penalty->refund_fee : json_decode($penalty->refund_fee, true);
                                            ?>
                                            <div class="p-3 border-bottom">
                                                <?php if(!empty($penalty->destination) || !empty($penalty->arrival)): ?>
                                                    <h6 class="mb-3 text-muted">
                                                        <?php echo e($penalty->destination); ?> → <?php echo e($penalty->arrival); ?>

                                                    </h6>
                                                <?php endif; ?>
                                                
                                                <?php
                                                    $sections = [
                                                        'Cancel Fees' => $cancel,
                                                        'Change Fees' => $change,
                                                        'Refund Policy / Fees' => $refund
                                                    ];
                                                ?>
                                                
                                                <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $title => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(!empty($data) && is_array($data)): ?>
                                                        <h6 class="mb-2"><?php echo e($title); ?></h6>
                                                        <table class="table table-sm align-middle mb-3">
                                                            <thead>
                                                                <tr>
                                                                    <th style="width: 40%">Type</th>
                                                                    <th style="width: 30%">Amount</th>
                                                                    <th style="width: 30%">Currency</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <tr>
                                                                        <td><?php echo e($fee['type_code'] ?? 'N/A'); ?></td>
                                                                        <td><?php echo e($fee['amount'] ?? ''); ?></td>
                                                                        <td><?php echo e($fee['currency'] ?? ''); ?></td>
                                                                    </tr>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </tbody>
                                                        </table>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                
                                                <?php if(empty($cancel) && empty($change) && empty($refund)): ?>
                                                    <p class="text-muted mb-0">No penalty info available.</p>
                                                <?php endif; ?>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                            <div class="p-3">
                                                <p class="text-muted mb-0">No penalties found for this booking item.</p>
                                            </div>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <p class="text-muted mb-0">No booking items found.</p>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <div class="p-3">
                                        <p class="text-muted mb-0">Unsupported airline for penalty information.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                 <?php $__env->slot('footer', null, []); ?> 
                    <button type="button" class="btn btn-danger cancelOrderBtn" data-booking-id="<?php echo e($booking->id); ?>" data-client-id="<?php echo e($booking->client_id); ?>">Cancel Booking</button>
                 <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
        </div>
    </div>

    <!-- Right Side -->
    <div class="col-md-9 right-side">
        
        <div class="d-block d-md-flex justify-content-between">
            <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn btn_secondary_outline d-flex align-items-center mb-3"><i class='bx bx-chevron-left'></i> Back to Order Management</a>
            <div class="btn-group d-block">
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('booking actions')): ?>
                    <button class="btn btn_secondary_outline" data-bs-toggle="modal" data-bs-target="#adminActions">Admin Actions</button>
                <?php endif; ?>
                <button class="btn btn_secondary_outline" data-bs-toggle="modal" data-bs-target="#fareRulesModal">Show Fare Rules</button>
                <button class="btn btn_<?php echo e($booking->client->status ? 'success' : 'danger'); ?>_outline"><?php echo e($booking->client->status ? 'Regular User' : 'Guest User'); ?></button>
                <button class="btn btn_<?php echo e($booking->status === 'issued' ? 'success' : 'danger'); ?>">Ticket <?php echo e(strtoupper($booking->status)); ?></button>
                <button class="btn btn_secondary_outline" data-bs-toggle="modal" data-bs-target="#detailedOverviewModal">Detailed Overview</button>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('issue tickets')): ?>
                    <?php if($booking->tickets->isEmpty()): ?>
                        <button class="btn btn-outline-dark updatePriceBtn" data-payment-exist="<?php echo e($booking->payments->isEmpty() ? 0 : 1); ?>" data-booking-id="<?php echo e($booking->id); ?>" data-client-id="<?php echo e($booking->client_id); ?>">Issue Tickets</button>
                    <?php endif; ?>
                <?php endif; ?>
                <?php if($booking->errorLogs->isNotEmpty()): ?>
                    <button class="btn btn_danger_outline" data-bs-toggle="modal" data-bs-target="#errorLogsModal">Error Logs</button>
                    <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'errorLogsModal','title' => 'Error Logs','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                        <div class="modal-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-dark">
                                        <tr>
                                            <th>#</th>
                                            <th>Error Type</th>
                                            <th>Message</th>
                                            
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $booking->errorLogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($index + 1); ?></td>
                                                <td><?php echo e(ucfirst($log->error_type)); ?></td>
                                                <td>
                                                    <?php
                                                        $errorMessage = json_decode($log->error_message, true);
                                                    ?>
                                                    <?php echo e(is_array($errorMessage) ? implode(', ', $errorMessage) : $log->error_message); ?>

                                                </td>
                                                
                                                <td><?php echo e(\Carbon\Carbon::parse($log->created_at)->format('d M Y h:i A')); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                         <?php $__env->slot('footer', null, []); ?> 
                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                         <?php $__env->endSlot(); ?>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
                <?php endif; ?>

            </div>
            <!-- Manage Admin Details -->
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('booking actions')): ?>
                <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'adminActions','title' => 'Update Booking Fields','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                    <form id="update-booking-<?php echo e($booking->id); ?>" method="POST" action="<?php echo e(route('admin.orders.booking.update', $booking)); ?>">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="modal-body">
                            <div class="row p-4 g-2">
                                <div class="col-md-4">
                                    <label class="form-label">Update Status</label>
                                    <select class="form-select" name="status">
                                        <?php $__currentLoopData = $booking->getStatuses(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($status); ?>" <?php echo e($status === $booking->status ? 'selected' : ''); ?>><?php echo e($status); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label">Update Booking PNR</label>
                                    <input name="order_id" type="text" class="form-control" value="<?php echo e($booking->order_id); ?>">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer w-100 d-flex justify-content-between">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete bookings')): ?>
                                <button type="button" class="btn btn-danger delete-booking-btn" data-id="<?php echo e($booking->id); ?>">
                                    Delete Booking
                                </button>
                            <?php endif; ?>
                            <button type="submit" class="btn btn_primary">Update</button>
                        </div>
                    </form>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete bookings')): ?>
                        <form id="delete-booking-<?php echo e($booking->id); ?>" method="POST" action="<?php echo e(route('admin.orders.booking.destroy', $booking)); ?>" class="d-none">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                        </form>
                    <?php endif; ?>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
            <?php endif; ?>
            <!-- Detailed Overview Modal -->
            <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'detailedOverviewModal','title' => 'Detailed Overview','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                <?php if (isset($component)) { $__componentOriginal9aa7b773b644e9e3ea75ed1784ad6b18 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9aa7b773b644e9e3ea75ed1784ad6b18 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.show-xml-data','data' => ['booking' => $booking]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.show-xml-data'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['booking' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($booking)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9aa7b773b644e9e3ea75ed1784ad6b18)): ?>
<?php $attributes = $__attributesOriginal9aa7b773b644e9e3ea75ed1784ad6b18; ?>
<?php unset($__attributesOriginal9aa7b773b644e9e3ea75ed1784ad6b18); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9aa7b773b644e9e3ea75ed1784ad6b18)): ?>
<?php $component = $__componentOriginal9aa7b773b644e9e3ea75ed1784ad6b18; ?>
<?php unset($__componentOriginal9aa7b773b644e9e3ea75ed1784ad6b18); ?>
<?php endif; ?>
                 <?php $__env->slot('footer', null, []); ?> 
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                 <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
            <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'fareRulesModal','title' => 'Fare Rules','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                <div class="modal-body">
                    <?php $__empty_1 = true; $__currentLoopData = $booking->bookingItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="border p-2 mb-3 rounded">
                            <h4><strong>Passenger:</strong> <?php echo e($item->passenger_code); ?><br></h4>
                            <?php
                                $services = json_decode($item->services, true);
                                $taxes = json_decode($item->taxes, true);
                                $totalTax = null;
                                if ($airline === 'flyjinnah' && is_array($taxes)) {
                                    $totalTax = array_sum(
                                        array_map(function ($tax) {
                                            return isset($tax['@attributes']['Amount']) ? (float) $tax['@attributes']['Amount'] : 0;
                                        }, $taxes),
                                    );
                                } elseif ($airline === 'pia' && is_array($taxes)) {
                                    $totalTax = array_sum(
                                        array_map(function ($tax) {
                                            return isset($tax['amount']) ? (float) $tax['amount'] : 0;
                                        }, $taxes),
                                    );
                                } elseif ($airline === 'airblue' && is_array($taxes)) {
                                    $totalTax = array_sum(
                                        array_map(function ($tax) {
                                            return isset($tax['Amount']) ? (float) $tax['Amount'] : 0;
                                        }, $taxes),
                                    );
                                }
                            ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <h6>Taxes</h6>
                                    <?php if($taxes && is_array($taxes)): ?>
                                        <?php if($airline === 'emirates' && isset($taxes['tax']) && is_array($taxes['tax'])): ?>
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $taxes['tax']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <strong><?php echo e($tax['taxCode']); ?></strong>:
                                                        <?php echo e($tax['description'] ?: 'N/A'); ?>

                                                        (<?php echo e($tax['price']['amount']); ?> <?php echo e($tax['price']['code']); ?>)
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <div class="mt-2">
                                                <strong>Base Amount:</strong> <?php echo e($taxes['baseAmount']['amount']); ?>

                                                <?php echo e($taxes['baseAmount']['code']); ?><br>
                                                <strong>Total Tax:</strong> <?php echo e($taxes['total']['amount']); ?>

                                                <?php echo e($taxes['total']['code']); ?>

                                            </div>
                                        <?php elseif($airline === 'flyjinnah'): ?>
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <strong><?php echo e($tax['@attributes']['TaxCode']); ?></strong>:
                                                        <?php echo e($tax['@attributes']['TaxName']); ?>

                                                        (<?php echo e($tax['@attributes']['Amount']); ?>

                                                        <?php echo e($tax['@attributes']['CurrencyCode']); ?>)
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <?php if($totalTax !== null): ?>
                                                <div class="mt-2">
                                                    <strong>Total Tax:</strong> <?php echo e(number_format($totalTax, 2)); ?>

                                                    <?php echo e($item->price_code); ?>

                                                </div>
                                            <?php endif; ?>
                                        <?php elseif($airline === 'pia'): ?>
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <strong><?php echo e($tax['tax_code']); ?></strong>:
                                                        <?php echo e($tax['tax_code']); ?> Tax
                                                        (<?php echo e($tax['amount']); ?> <?php echo e($item->price_code); ?>)
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <?php if($totalTax !== null): ?>
                                                <div class="mt-2">
                                                    <strong>Total Tax:</strong> <?php echo e(number_format($totalTax, 2)); ?>

                                                    <?php echo e($item->price_code); ?>

                                                </div>
                                            <?php endif; ?>
                                        <?php elseif($airline === 'airblue'): ?>
                                            <ul class="mb-0">
                                                <?php $__currentLoopData = $taxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li>
                                                        <strong><?php echo e($tax['TaxCode'] ?? 'N/A'); ?></strong>:
                                                        <?php echo e($tax['TaxCode'] ?? 'N/A'); ?> Tax
                                                        (<?php echo e($tax['Amount'] ?? '0'); ?>

                                                        <?php echo e($tax['CurrencyCode'] ?? $item->price_code); ?>)
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                            <?php if($totalTax !== null): ?>
                                                <div class="mt-2">
                                                    <strong>Total Tax:</strong> <?php echo e(number_format($totalTax, 2)); ?>

                                                    <?php echo e($item->price_code); ?>

                                                </div>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <p>Unsupported tax format for airline.</p>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <p>No taxes available.</p>
                                    <?php endif; ?>
                                </div>
                                <div class="col-md-6">
                                    <h6>Services</h6>
                                    <?php if($services && is_array($services)): ?>
                                        <ul class="mb-0">
                                            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($airline === 'emirates' && !empty($service['details']['details'])): ?>
                                                    <li><?php echo e($service['details']['details']); ?></li>
                                                <?php elseif($airline === 'flyjinnah'): ?>
                                                    <li><?php echo e($service); ?></li>
                                                <?php elseif($airline === 'pia'): ?>
                                                    <li>
                                                        <?php echo e($service['service_definition_id'] ?: 'Flight Service'); ?>

                                                        (Segments: <?php echo e(implode(', ', $service['segment_refs'])); ?>)
                                                    </li>
                                                <?php elseif($airline === 'airblue'): ?>
                                                    <li>
                                                        <strong><?php echo e($service['title'] ?? 'N/A'); ?></strong>
                                                        <?php if(!empty($service['description'])): ?>
                                                            <br><small
                                                                class="text-muted"><?php echo e($service['description']); ?></small>
                                                        <?php endif; ?>
                                                        <br>
                                                        <small>
                                                            SSR Code: <?php echo e($service['ssr_code'] ?? 'N/A'); ?> |
                                                            Item Code: <?php echo e($service['item_code'] ?? 'N/A'); ?> |
                                                            Flight RPH: <?php echo e($service['flight_rph'] ?? 'N/A'); ?>

                                                        </small>
                                                        <br>
                                                        <small>
                                                            Price:
                                                            <?php echo e(!empty($service['price']) && !empty($service['currency']) ? $service['currency'] . ' ' . number_format($service['price'], 2) : 'Free'); ?>

                                                            |
                                                            Status: <?php echo e($service['status'] ?? 'N/A'); ?> |
                                                            Refundable:
                                                            <?php echo e(!empty($service['refundable']) ? ($service['refundable'] === 'true' ? 'Yes' : 'No') : 'N/A'); ?>

                                                        </small>
                                                        <?php if(!empty($service['expires'])): ?>
                                                            <br><small class="text-warning">Expires:
                                                                <?php echo e(\Carbon\Carbon::parse($service['expires'])->format('d M Y, H:i')); ?></small>
                                                        <?php endif; ?>
                                                    </li>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php else: ?>
                                        <p>No services available.</p>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <?php if($airline === 'flyjinnah' || $airline === 'airblue'): ?>
                                <div class="mt-2">
                                    <strong>Total Price:</strong> <?php echo e(number_format($item->price, 2)); ?>

                                    <?php echo e($item->price_code); ?>

                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p>No booking items found.</p>
                    <?php endif; ?>
                </div>
                 <?php $__env->slot('footer', null, []); ?> 
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                 <?php $__env->endSlot(); ?>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
            <!-- Approve Flight Modal -->
            <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'issueTicketsModal','title' => 'Issue Tickets','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                <div class="modal-body issueTicketsBody">
                    
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn_primary issueTicketBtn" data-booking-id="<?php echo e($booking->id); ?>" data-client-id="<?php echo e($booking->client_id); ?>">Approve & Issue Tickets</button>
                </div>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
        </div>
        
        <div class="card box">
            <div class="row">
                <div class="col-md-4 py-2"><strong>Order Ref:</strong> <?php echo e($booking->id); ?></div>
                <div class="col-md-4 py-2"><strong>Web Ref:</strong> <?php echo e($booking->transaction_id); ?></div>
                <div class="col-md-4 py-2"><strong>Order Status:</strong> <span class="badge bg-<?php echo e($booking->status === 'issued' ? 'success' : 'danger'); ?>">TICKET<?php echo e(strtoupper($booking->status)); ?></span></div>
            </div>
            <div class="row mt-2">
                <div class="col-md-4 py-2"><strong>Order Total:</strong> <?php echo e($booking->total_price); ?></div>
                <div class="col-md-4 py-2"><strong>Source/Affiliate:</strong> EDestinations Web</div>
                <div class="col-md-4 py-2"><strong>IP of the User:</strong> <?php echo e($booking->client->ip ?? ''); ?></div>
            </div>
        </div>
        
        <div class="card box">
            <div class="section-title">Order Details</div>
            <table class="table table-bordered">
                <thead>
                <tr>
                    <th>Airline Ref</th>
                    
                    <th>Flight No</th>
                    <th>Origin/Destination</th>
                    <th>Stops</th>
                    <th>Departure</th>
                    <th>Arrival</th>
                    <th>Duration</th>
                    <th>Class</th>
                </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $booking->flights; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $flight): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $flight->segments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $segment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($flight->airline); ?></td>
                                
                                
                                <td><?php echo e($segment->flight_number); ?></td>
                                <td><?php echo e($segment->departure_code); ?> - <?php echo e($segment->arrival_code); ?></td>
                                <td><?php echo e($flight->is_connected ? '1' : '0'); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($segment->departure_date)->format('d M Y H:i')); ?></td>
                                <td><?php echo e(\Carbon\Carbon::parse($segment->arrival_date)->format('d M Y H:i')); ?></td>
                                <td><?php echo e($segment->formatted_duration); ?></td>
                                <td><?php echo e($flight->cabin_name_with_code); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="card box">
            <div class="section-title">
                Ticket Details
                
            </div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Passenger Name</th>
                        <th>Date Of Birth</th>
                        <th>Type</th>
                        <th>Nationality</th>
                        <th>Passport Number / NIC</th>
                        <th>Expiry</th>
                        <th>Airline PNR</th>
                        <th>GDS PNR</th>
                        <th>Ticket Number</th>
                        <th>Price</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <?php
                    $passengers = is_string($booking->passenger_details) ? (json_decode($booking->passenger_details, true) ?? []) : $booking->passenger_details;
                    $tickets = $booking->tickets->keyBy('passenger_reference');
                ?>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $passengers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $passenger): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $ticket = $tickets[$passenger['passenger_reference'] ?? ''] ?? null;
                        ?>
                        <tr>
                            <td><?php echo e(strtoupper($passenger['title'])); ?> <?php echo e($passenger['given_name'] ?? ''); ?> <?php echo e($passenger['surname']); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($passenger['dob'] ?? '')->format('d/m/Y')); ?></td>
                            <td><?php echo e($passenger['type'] ?? ''); ?></td>
                            <td><?php echo e($passenger['nationality'] ?? 'N/A'); ?></td>
                            <td><?php echo e($passenger['passport_no'] ?? 'N/A'); ?></td>
                            <td><?php echo e(\Carbon\Carbon::parse($passenger['passport_exp'] ?? '')->format('d/m/Y')); ?></td>
                            <td><?php echo e($booking->airline_id ?? $booking->order_id); ?></td>
                            <td><?php echo e($booking->flight_booking_id); ?>-<?php echo e($loop->iteration); ?></td>

                            <?php if($ticket): ?>
                                <td><?php echo e($ticket->ticket_no ?? ''); ?></td>
                                <td><?php echo e(number_format($ticket->price)); ?> <?php echo e($ticket->price_code); ?></td>
                                <td>
                                    <span class="badge p-1 bg-<?php echo e($ticket->status === 'success' ? 'success' : 'danger'); ?>">
                                        <?php echo e(strtoupper($ticket->status ?? '')); ?>

                                    </span>
                                </td>
                            <?php else: ?>
                                <?php if($booking->status === 'issued'): ?>
                                <form action="<?php echo e(route('admin.orders.ticket.create')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <input type="hidden" name="booking_id" value="<?php echo e($booking->id); ?>">
                                    <input type="hidden" name="passenger_reference" value="<?php echo e($passenger['passenger_reference'] ?? ''); ?>">
                                    <input type="hidden" name="type" value="<?php echo e($passenger['type'] ?? ''); ?>">
                                    <td><input name="ticket_number" type="text" class="form-control m-0 p-0 px-2" required></td>
                                    <td colspan="2"><input type="submit" class="form-control m-0 p-0 px-2" value="Add ticket"></td>
                                </form>
                                <?php else: ?>
                                    <td colspan="3" class="text-center"><span class="text-danger">Not issued</span></td>
                                <?php endif; ?>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="11" class="text-center text-muted">No passengers found.</td></tr>
                    <?php endif; ?>

                </tbody>
            </table>
        </div>
        
        
        <div class="card box">
            <div class="section-title">Product Overview</div>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Type</th>
                        <th>Provider</th>
                        <th>Supplier</th>
                        <th>Base Fare</th>
                        <th>Tax</th>
                        <th>POS Rule</th>
                        <th>Displayed Price</th>
                        <th>PNR Expires At</th>
                        <th>Booking Expires At</th>
                        
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo e($booking->is_oneway ? 'Oneway' : 'Return'); ?> Flight</td>
                        <td><?php echo e($booking->airline ?? ''); ?>Api</td>
                        <td><?php echo e($booking->airline ?? ''); ?></td>
                        <td><?php echo e($booking->total_price ?? 0); ?></td>
                        <td><?php echo e($booking->tax ?? 0); ?></td>
                        <td>Affiliation POS Rule</td>
                        <td><?php echo e($booking->total_tax_price ?? 0); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($booking->payment_limit)->format('d M Y h:i A')); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($booking->ticket_limit)->format('d M Y h:i A')); ?></td>
                        
                    </tr>
                </tbody>
            </table>
        </div>
        
        <div class="card box">
            <div class="section-title">
                Payments
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage payment')): ?>
                    <button class="btn btn_secondary_outline m-1 float-end" data-bs-toggle="modal" data-bs-target="#addPayment" type="button">Add Payment</button>
                <?php endif; ?>
            </div>

            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Created at</th>
                        <th>Payment Method</th>
                        <th>Transaction ID</th>
                        <th>Displayed Price</th>
                        <th>Merchant Fee</th>
                        <th>Service Fee</th>
                        <th>Status</th>
                        <th>Refund Status</th>
                        <th>Selling Fare</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $booking->payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td><?php echo e($payment->created_at->format('d M Y h:i a')); ?></td>
                            <td><?php echo e($payment->payment_method); ?></td>
                            <td><?php echo e($payment->transaction_id); ?></td>
                            <td><?php echo e($payment->base_price_code); ?> <?php echo e(number_format($payment->base_price + $payment->tax, 2)); ?></td>
                            <td><?php echo e($payment->merchant_fee); ?>%</td>
                            <td><?php echo e($payment->service_fee); ?></td>
                            <td><?php echo e(ucfirst($payment->status)); ?></td>
                            <td><?php echo e($payment->refund_status ?? 'N/A'); ?></td>
                            <td><?php echo e($payment->base_price_code); ?> <?php echo e(number_format($payment->base_price, 2)); ?></td>
                            <td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage payment')): ?>
                                    <button class="btn btn_secondary_outline" data-bs-toggle="modal" data-bs-target="#editPayment<?php echo e($payment->id); ?>">Adjust</button>
                                <?php endif; ?>
                            </td>
                        </tr>

                        
                        <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'editPayment'.e($payment->id).'','title' => 'Edit Payment','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                            
                            <form id="update-payment-<?php echo e($payment->id); ?>" method="POST" action="<?php echo e(route('admin.orders.payment.update', $payment)); ?>">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="modal-body">
                                    <?php if (isset($component)) { $__componentOriginal257851cdeff502c608291388060fa916 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal257851cdeff502c608291388060fa916 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.payment-form','data' => ['payment' => $payment]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.payment-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['payment' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($payment)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal257851cdeff502c608291388060fa916)): ?>
<?php $attributes = $__attributesOriginal257851cdeff502c608291388060fa916; ?>
<?php unset($__attributesOriginal257851cdeff502c608291388060fa916); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal257851cdeff502c608291388060fa916)): ?>
<?php $component = $__componentOriginal257851cdeff502c608291388060fa916; ?>
<?php unset($__componentOriginal257851cdeff502c608291388060fa916); ?>
<?php endif; ?>
                                </div>
                                <div class="modal-footer w-100 d-flex justify-content-between">
                                    
                                    <button type="button" class="btn btn-danger delete-payment-btn" data-id="<?php echo e($payment->id); ?>">
                                        Delete
                                    </button>
                                    <button type="submit" class="btn btn_primary">Update</button>
                                </div>
                            </form>

                            
                            <form id="delete-payment-<?php echo e($payment->id); ?>" method="POST" action="<?php echo e(route('admin.orders.payment.destroy', $payment)); ?>" class="d-none">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('DELETE'); ?>
                            </form>
                         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr><td colspan="10" class="text-center">No Payment Found</td></tr>
                    <?php endif; ?>

                </tbody>
            </table>

            
            <?php if (isset($component)) { $__componentOriginale6a555649da86b3de44465cdfe004aa4 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale6a555649da86b3de44465cdfe004aa4 = $attributes; } ?>
<?php $component = App\View\Components\Modal::resolve(['id' => 'addPayment','title' => 'Add Payment','size' => 'modal-lg'] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Modal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
                <form method="POST" action="<?php echo e(route('admin.orders.payment.store')); ?>">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="booking_id" value="<?php echo e($booking->id); ?>">
                    <input type="hidden" name="client_id" value="<?php echo e($booking->client_id); ?>">
                    <input type="hidden" name="airline" value="<?php echo e($booking->airline); ?>">
                    <div class="modal-body">
                        <?php if (isset($component)) { $__componentOriginal257851cdeff502c608291388060fa916 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal257851cdeff502c608291388060fa916 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin.payment-form','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin.payment-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal257851cdeff502c608291388060fa916)): ?>
<?php $attributes = $__attributesOriginal257851cdeff502c608291388060fa916; ?>
<?php unset($__attributesOriginal257851cdeff502c608291388060fa916); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal257851cdeff502c608291388060fa916)): ?>
<?php $component = $__componentOriginal257851cdeff502c608291388060fa916; ?>
<?php unset($__componentOriginal257851cdeff502c608291388060fa916); ?>
<?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn_primary">Add Payment</button>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </form>
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $attributes = $__attributesOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__attributesOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale6a555649da86b3de44465cdfe004aa4)): ?>
<?php $component = $__componentOriginale6a555649da86b3de44465cdfe004aa4; ?>
<?php unset($__componentOriginale6a555649da86b3de44465cdfe004aa4); ?>
<?php endif; ?>
        </div>
        
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>

<!-- Summernote CSS & JS -->
<link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-lite.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-lite.min.js"></script>
<script>
    $(document).ready(function() {
        let jsessionId, transactionId;
        let airline = "<?php echo e($booking->airline); ?>".toLowerCase();
        $(document).on({
            ajaxStart: () => _loader('show'),
            ajaxStop: () => _loader('hide')
        });
        // Notes
        $('#note-editor').summernote({
            height: 150,
            placeholder: 'Write your note here...',
            toolbar: [
                ['style', ['bold', 'italic', 'underline', 'clear']],
                ['para', ['ul', 'ol', 'paragraph']],
                ['insert', ['link']],
                ['view', ['codeview']]
            ]
        });
        $('#addNoteBtn').on('click', function () {
            const agentId = $('#agentSelect').val();
            const note = $('#note-editor').val();
            const bookingId = <?php echo e($booking->id); ?>;
            const image = $('#noteImage')[0].files[0];

            if (!agentId) return _alert("Please select an agent first.", "warning");

            if (!note.trim()) return _alert("Note content cannot be empty.", "warning");

            let formData = new FormData();
            formData.append('agent_id', agentId);
            formData.append('booking_id', bookingId);
            formData.append('notes', note);
            if (image) formData.append('image', image);
            formData.append('_token', '<?php echo e(csrf_token()); ?>');

            $.ajax({
                url: '<?php echo e(route("admin.orders.log.add")); ?>',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                success: function (res) {
                    _alert("Note added successfully.");
                    $('#note-editor').val('');
                    $('#noteImage').val('');
                },
                error: function (xhr) {
                    _alert("Something went wrong. Try again.", "error");
                }
            });
        });
        $('#showLogHistoryBtn').on('click', function () {
            let bookingId = <?php echo e($booking->id); ?>;

            $('#logHistoryContent').html('<div class="text-center py-4">Loading...</div>');
            $('#logHistoryModal').modal('show');

            $.ajax({
                url: "<?php echo e(route('admin.orders.booking.logs', ':id')); ?>".replace(':id', bookingId),
                method: 'GET',
                success: function (response) {
                    let logs = response.logs;
                    if (logs.length === 0) return $('#logHistoryContent').html('<div class="alert alert-info">No notes found.</div>');

                    let html = '<ul class="list-group">';
                    logs.forEach(log => {
                        html += `
                            <li class="list-group-item">
                                <strong>${log.user?.email || 'agent@edestination.com'}</strong>
                                <span class="text-muted float-end">${new Date(log.created_at).toLocaleString()}</span>
                                <p class="mb-1">${log.notes}</p>
                                ${log.image ? `<img src="/storage/${log.image}" alt="note image" class="img-thumbnail" style="max-width: 200px;">` : ''}
                            </li>
                        `;
                    });
                    html += '</ul>';

                    $('#logHistoryContent').html(html);
                },
                error: function () {
                    $('#logHistoryContent').html('<div class="alert alert-danger">Failed to load notes.</div>');
                }
            });
        });
        // Notes
        // payment
        $('.delete-payment-btn').on('click', async function (e) {
            e.preventDefault();
            const id = $(this).data('id');
            const ok = await _confirm('Are you sure you want to delete this payment?', true, 'warning', 'Yes, delete');
            if (ok) {
                document.getElementById('delete-payment-' + id).submit();
            }
        });
        // Issue Tickets (Fetch Details)
        $('.updatePriceBtn').on('click', async function (e) {
            let bookingId = $(this).data('booking-id');
            let clientId = $(this).data('client-id');
            let paymentExist = $(this).data('payment-exist');
            if (paymentExist == 0) return _alert('Please add some payments before issue tickets', 'warning')
            const ok = await _confirm('Are you sure you want to issue tickets for this flight?', true, 'warning', 'Yes');
            if (ok) {
                $.ajax({
                    url: "<?php echo e(route('fetch.flight.details')); ?>",
                    type: "POST",
                    data: { bookingId, clientId },
                    headers: {
                        'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                        'Accept': 'application/json'
                    },
                    success: function (res) {
                        if (res.status === 'success') {
                            // Build price comparison HTML
                            let comp = res.comparison;
                            if (airline === 'flyjinnah') {
                                jsessionId = res.data.jsessionId;
                                transactionId = res.data.transactionId;
                            }
                            let html = `
                                <div class="p-3">
                                    <h5>Price Comparison</h5>
                                    <table class="table table-bordered">
                                        <tr>
                                            <th>Old Price</th>
                                            <td>${comp.old_price} ${comp.old_price_code}</td>
                                        </tr>
                                        <tr>
                                            <th>New Price</th>
                                            <td>${comp.new_price} ${comp.new_price_code ?? ''}</td>
                                        </tr>
                                        <tr>
                                            <th>Difference</th>
                                            <td>
                                                ${comp.difference} 
                                                (${comp.difference_label})
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>Percent Change</th>
                                            <td>${comp.percent_change}%</td>
                                        </tr>
                                    </table>
                                    <p class="text-muted">Approve the booking if you agree with the updated price.</p>
                                </div>
                            `;
                            $(".issueTicketsBody").html(html);
                            // Show modal
                            $("#issueTicketsModal").modal('show');
                        } else {
                            _alert(res.message || 'Error fetching booking details', 'error');
                        }
                    },
                    error: function (xhr) {
                        _alert(xhr.responseJSON.message || 'Error fetching booking details', 'error');
                    }
                });
            }
        });
        // Issue Tickets
        $('.issueTicketBtn').on('click', async function (e) {
            let bookingId = $(this).data('booking-id');
            let clientId = $(this).data('client-id');
            $.ajax({
                url: "<?php echo e(route('confirm.booking')); ?>",
                type: "POST",
                data: {bookingId, clientId, jsessionId, transactionId},
                headers: {
                    'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                    'Accept': 'application/json'
                },
                success: function (res) {
                    if (res.status === 'success') {
                        _alert('Booking approved and tickets issued successfully!', 'success');
                        $("#issueTicketsModal").modal('hide');
                        setTimeout(function () {
                            window.location.reload();
                        }, 3000);
                    } else {
                        _alert(res.message || 'Error confirming booking', 'error');
                    }
                },
                error: function (xhr) {
                    _alert(xhr.responseJSON.message || 'Error confirming booking', 'error');
                    // Show Error Details Here in sweet alert
                }
            });
        });
        $('.cancelOrderBtn').on('click', async function (e) {
            let bookingId = $(this).data('booking-id');
            let clientId = $(this).data('client-id');
            let paymentExist = $(this).data('payment-exist');
            if (paymentExist == 0) return _alert('Please add some payments before issue tickets', 'warning')
            const ok = await _confirm('Are you sure you want to cancel this booking?', true, 'warning', 'Yes');
            if (ok) {
                $.ajax({
                    url: "<?php echo e(route('cancel.booking')); ?>",
                    type: "POST",
                    data: { bookingId, clientId },
                    headers: {
                        'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>",
                        'Accept': 'application/json'
                    },
                    success: function (res) {
                        if (res.status === 'success') {
                            _alert('Booking canceled successfully!', 'success');
                            $("#cacelOrderDetailsModal").modal('hide');
                            setTimeout(function () {
                            window.location.reload();
                        }, 3000);
                        } else {
                            _alert(res.message || 'Error in cancel booking', 'error');
                        }
                    },
                    error: function (xhr) {
                        let errorDetails = xhr.responseJSON.message || 'Error in cancel booking';
                        _alert(errorDetails, 'error');
                    }
                });
            } else {
                $("#cacelOrderDetailsModal").modal('hide');
            }
        });
        $('.delete-booking-btn').on('click', async function (e) {
            e.preventDefault();
            const id = $(this).data('id');
            const ok = await _confirm('Are you sure you want to delete this booking?', true, 'warning', 'Yes, delete');
            if (ok) {
                document.getElementById('delete-booking-' + id).submit();
            }
        });
    });
</script>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin/layouts/master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\wamp64\www\destination-travel\resources\views/admin/orders/manage.blade.php ENDPATH**/ ?>